/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JobActivationRequest {
    private String type;
    private String worker = null;
    private Long timeout;
    private Integer maxJobsToActivate;
    @Valid
    private List<String> fetchVariable;
    private Long requestTimeout = null;
    @Valid
    private List<String> tenantIds;

    public JobActivationRequest() {
    }

    public JobActivationRequest(String type, Long timeout, Integer maxJobsToActivate) {
        this.type = type;
        this.timeout = timeout;
        this.maxJobsToActivate = maxJobsToActivate;
    }

    public JobActivationRequest type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="type", description="the job type, as defined in the BPMN process (e.g. <zeebe:taskDefinition type=\"payment-service\" />) ", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public JobActivationRequest worker(String worker) {
        this.worker = worker;
        return this;
    }

    @Schema(name="worker", description="the name of the worker activating the jobs, mostly used for logging purposes", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="worker")
    public String getWorker() {
        return this.worker;
    }

    public void setWorker(String worker) {
        this.worker = worker;
    }

    public JobActivationRequest timeout(Long timeout) {
        this.timeout = timeout;
        return this;
    }

    @NotNull
    @Schema(name="timeout", description="a job returned after this call will not be activated by another call until the timeout (in ms) has been reached ", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="timeout")
    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public JobActivationRequest maxJobsToActivate(Integer maxJobsToActivate) {
        this.maxJobsToActivate = maxJobsToActivate;
        return this;
    }

    @NotNull
    @Schema(name="maxJobsToActivate", description="the maximum jobs to activate by this request", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="maxJobsToActivate")
    public Integer getMaxJobsToActivate() {
        return this.maxJobsToActivate;
    }

    public void setMaxJobsToActivate(Integer maxJobsToActivate) {
        this.maxJobsToActivate = maxJobsToActivate;
    }

    public JobActivationRequest fetchVariable(List<String> fetchVariable) {
        this.fetchVariable = fetchVariable;
        return this;
    }

    public JobActivationRequest addFetchVariableItem(String fetchVariableItem) {
        if (this.fetchVariable == null) {
            this.fetchVariable = new ArrayList<String>();
        }
        this.fetchVariable.add(fetchVariableItem);
        return this;
    }

    @Schema(name="fetchVariable", description="a list of variables to fetch as the job variables; if empty, all visible variables at the time of activation for the scope of the job will be returned ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="fetchVariable")
    public List<String> getFetchVariable() {
        return this.fetchVariable;
    }

    public void setFetchVariable(List<String> fetchVariable) {
        this.fetchVariable = fetchVariable;
    }

    public JobActivationRequest requestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Schema(name="requestTimeout", description="The request will be completed when at least one job is activated or after the requestTimeout (in ms). If the requestTimeout = 0, a default timeout is used. If the requestTimeout < 0, long polling is disabled and the request is completed immediately, even when no job is activated. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="requestTimeout")
    public Long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public JobActivationRequest tenantIds(List<String> tenantIds) {
        this.tenantIds = tenantIds;
        return this;
    }

    public JobActivationRequest addTenantIdsItem(String tenantIdsItem) {
        if (this.tenantIds == null) {
            this.tenantIds = new ArrayList<String>();
        }
        this.tenantIds.add(tenantIdsItem);
        return this;
    }

    @Schema(name="tenantIds", description="a list of IDs of tenants for which to activate jobs", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantIds")
    public List<String> getTenantIds() {
        return this.tenantIds;
    }

    public void setTenantIds(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobActivationRequest jobActivationRequest = (JobActivationRequest)o;
        return Objects.equals(this.type, jobActivationRequest.type) && Objects.equals(this.worker, jobActivationRequest.worker) && Objects.equals(this.timeout, jobActivationRequest.timeout) && Objects.equals(this.maxJobsToActivate, jobActivationRequest.maxJobsToActivate) && Objects.equals(this.fetchVariable, jobActivationRequest.fetchVariable) && Objects.equals(this.requestTimeout, jobActivationRequest.requestTimeout) && Objects.equals(this.tenantIds, jobActivationRequest.tenantIds);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.worker, this.timeout, this.maxJobsToActivate, this.fetchVariable, this.requestTimeout, this.tenantIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobActivationRequest {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    worker: ").append(this.toIndentedString(this.worker)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    maxJobsToActivate: ").append(this.toIndentedString(this.maxJobsToActivate)).append("\n");
        sb.append("    fetchVariable: ").append(this.toIndentedString(this.fetchVariable)).append("\n");
        sb.append("    requestTimeout: ").append(this.toIndentedString(this.requestTimeout)).append("\n");
        sb.append("    tenantIds: ").append(this.toIndentedString(this.tenantIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

