/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class IncidentFilterRequest {
    private Long key;
    private Long processDefinitionKey;
    private String processDefinitionId;
    private Long processInstanceKey;
    private ErrorTypeEnum errorType;
    private String errorMessage;
    private String flowNodeId;
    private Long flowNodeInstanceKey;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String creationTime;
    private StateEnum state;
    private Long jobKey;
    private String treePath;
    private String tenantId;

    public IncidentFilterRequest key(Long key) {
        this.key = key;
        return this;
    }

    @Schema(name="key", description="The assigned key, which acts as a unique identifier for this incident.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="key")
    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public IncidentFilterRequest processDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Schema(name="processDefinitionKey", description="The process definition key associated to this incident.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionKey")
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public IncidentFilterRequest processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Schema(name="processDefinitionId", description="The bpmn process id associated to this incident.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionId")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public IncidentFilterRequest processInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @Schema(name="processInstanceKey", description="The process instance key associated to this incident.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processInstanceKey")
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public IncidentFilterRequest errorType(ErrorTypeEnum errorType) {
        this.errorType = errorType;
        return this;
    }

    @Schema(name="errorType", description="Incident error type with a defined set of values.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="errorType")
    public ErrorTypeEnum getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorTypeEnum errorType) {
        this.errorType = errorType;
    }

    public IncidentFilterRequest errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Schema(name="errorMessage", description="Error message which describes the error in more detail.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public IncidentFilterRequest flowNodeId(String flowNodeId) {
        this.flowNodeId = flowNodeId;
        return this;
    }

    @Schema(name="flowNodeId", description="The flow node id associated to this incident.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="flowNodeId")
    public String getFlowNodeId() {
        return this.flowNodeId;
    }

    public void setFlowNodeId(String flowNodeId) {
        this.flowNodeId = flowNodeId;
    }

    public IncidentFilterRequest flowNodeInstanceKey(Long flowNodeInstanceKey) {
        this.flowNodeInstanceKey = flowNodeInstanceKey;
        return this;
    }

    @Schema(name="flowNodeInstanceKey", description="The flow node instance key associated to this incident.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="flowNodeInstanceKey")
    public Long getFlowNodeInstanceKey() {
        return this.flowNodeInstanceKey;
    }

    public void setFlowNodeInstanceKey(Long flowNodeInstanceKey) {
        this.flowNodeInstanceKey = flowNodeInstanceKey;
    }

    public IncidentFilterRequest creationTime(String creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @Valid
    @Schema(name="creationTime", description="Date of incident creation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="creationTime")
    public String getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    public IncidentFilterRequest state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Schema(name="state", description="State of this incident with a defined set of values.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public IncidentFilterRequest jobKey(Long jobKey) {
        this.jobKey = jobKey;
        return this;
    }

    @Schema(name="jobKey", description="The job key, if exists, associated with this incident.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="jobKey")
    public Long getJobKey() {
        return this.jobKey;
    }

    public void setJobKey(Long jobKey) {
        this.jobKey = jobKey;
    }

    public IncidentFilterRequest treePath(String treePath) {
        this.treePath = treePath;
        return this;
    }

    @Schema(name="treePath", description="The path from process instance via flow node ids and flow node instance keys leading to this incident.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="treePath")
    public String getTreePath() {
        return this.treePath;
    }

    public void setTreePath(String treePath) {
        this.treePath = treePath;
    }

    public IncidentFilterRequest tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant id of the incident.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentFilterRequest incidentFilterRequest = (IncidentFilterRequest)o;
        return Objects.equals(this.key, incidentFilterRequest.key) && Objects.equals(this.processDefinitionKey, incidentFilterRequest.processDefinitionKey) && Objects.equals(this.processDefinitionId, incidentFilterRequest.processDefinitionId) && Objects.equals(this.processInstanceKey, incidentFilterRequest.processInstanceKey) && Objects.equals((Object)this.errorType, (Object)incidentFilterRequest.errorType) && Objects.equals(this.errorMessage, incidentFilterRequest.errorMessage) && Objects.equals(this.flowNodeId, incidentFilterRequest.flowNodeId) && Objects.equals(this.flowNodeInstanceKey, incidentFilterRequest.flowNodeInstanceKey) && Objects.equals(this.creationTime, incidentFilterRequest.creationTime) && Objects.equals((Object)this.state, (Object)incidentFilterRequest.state) && Objects.equals(this.jobKey, incidentFilterRequest.jobKey) && Objects.equals(this.treePath, incidentFilterRequest.treePath) && Objects.equals(this.tenantId, incidentFilterRequest.tenantId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.processDefinitionKey, this.processDefinitionId, this.processInstanceKey, this.errorType, this.errorMessage, this.flowNodeId, this.flowNodeInstanceKey, this.creationTime, this.state, this.jobKey, this.treePath, this.tenantId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentFilterRequest {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processInstanceKey: ").append(this.toIndentedString(this.processInstanceKey)).append("\n");
        sb.append("    errorType: ").append(this.toIndentedString((Object)this.errorType)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    flowNodeId: ").append(this.toIndentedString(this.flowNodeId)).append("\n");
        sb.append("    flowNodeInstanceKey: ").append(this.toIndentedString(this.flowNodeInstanceKey)).append("\n");
        sb.append("    creationTime: ").append(this.toIndentedString(this.creationTime)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    jobKey: ").append(this.toIndentedString(this.jobKey)).append("\n");
        sb.append("    treePath: ").append(this.toIndentedString(this.treePath)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ErrorTypeEnum {
        UNSPECIFIED("UNSPECIFIED"),
        UNKNOWN("UNKNOWN"),
        IO_MAPPING_ERROR("IO_MAPPING_ERROR"),
        JOB_NO_RETRIES("JOB_NO_RETRIES"),
        CONDITION_ERROR("CONDITION_ERROR"),
        EXTRACT_VALUE_ERROR("EXTRACT_VALUE_ERROR"),
        CALLED_ELEMENT_ERROR("CALLED_ELEMENT_ERROR"),
        UNHANDLED_ERROR_EVENT("UNHANDLED_ERROR_EVENT"),
        MESSAGE_SIZE_EXCEEDED("MESSAGE_SIZE_EXCEEDED"),
        CALLED_DECISION_ERROR("CALLED_DECISION_ERROR"),
        DECISION_EVALUATION_ERROR("DECISION_EVALUATION_ERROR"),
        FORM_NOT_FOUND("FORM_NOT_FOUND");

        private String value;

        private ErrorTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ErrorTypeEnum fromValue(String value) {
            for (ErrorTypeEnum b : ErrorTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StateEnum {
        ACTIVE("ACTIVE"),
        MIGRATED("MIGRATED"),
        RESOLVED("RESOLVED"),
        PENDING("PENDING");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

