/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FlowNodeInstanceFilterRequest {
    private Long flowNodeInstanceKey;
    private Long processInstanceKey;
    private Long processDefinitionKey;
    private String state;
    private String type;
    private String flowNodeId;
    private String flowNodeName;
    private String treePath;
    private Boolean incident;
    private Long incidentKey;
    private String tenantId;

    public FlowNodeInstanceFilterRequest flowNodeInstanceKey(Long flowNodeInstanceKey) {
        this.flowNodeInstanceKey = flowNodeInstanceKey;
        return this;
    }

    @Schema(name="flowNodeInstanceKey", description="The key of this flow node instance.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="flowNodeInstanceKey")
    public Long getFlowNodeInstanceKey() {
        return this.flowNodeInstanceKey;
    }

    public void setFlowNodeInstanceKey(Long flowNodeInstanceKey) {
        this.flowNodeInstanceKey = flowNodeInstanceKey;
    }

    public FlowNodeInstanceFilterRequest processInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @Schema(name="processInstanceKey", description="The process instance key.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processInstanceKey")
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public FlowNodeInstanceFilterRequest processDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Schema(name="processDefinitionKey", description="The process definition key.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionKey")
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public FlowNodeInstanceFilterRequest state(String state) {
        this.state = state;
        return this;
    }

    @Schema(name="state", description="The state, one of ACTIVE, COMPLETED, TERMINATED.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="state")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public FlowNodeInstanceFilterRequest type(String type) {
        this.type = type;
        return this;
    }

    @Schema(name="type", description="The flow node type", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public FlowNodeInstanceFilterRequest flowNodeId(String flowNodeId) {
        this.flowNodeId = flowNodeId;
        return this;
    }

    @Schema(name="flowNodeId", description="The flow node id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="flowNodeId")
    public String getFlowNodeId() {
        return this.flowNodeId;
    }

    public void setFlowNodeId(String flowNodeId) {
        this.flowNodeId = flowNodeId;
    }

    public FlowNodeInstanceFilterRequest flowNodeName(String flowNodeName) {
        this.flowNodeName = flowNodeName;
        return this;
    }

    @Schema(name="flowNodeName", description="The flow node name", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="flowNodeName")
    public String getFlowNodeName() {
        return this.flowNodeName;
    }

    public void setFlowNodeName(String flowNodeName) {
        this.flowNodeName = flowNodeName;
    }

    public FlowNodeInstanceFilterRequest treePath(String treePath) {
        this.treePath = treePath;
        return this;
    }

    @Schema(name="treePath", description="The path of keys from process instance to this flow node instance separated by '/'", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="treePath")
    public String getTreePath() {
        return this.treePath;
    }

    public void setTreePath(String treePath) {
        this.treePath = treePath;
    }

    public FlowNodeInstanceFilterRequest incident(Boolean incident) {
        this.incident = incident;
        return this;
    }

    @Schema(name="incident", description="Shows whether this flow node instance has an incident related to", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="incident")
    public Boolean getIncident() {
        return this.incident;
    }

    public void setIncident(Boolean incident) {
        this.incident = incident;
    }

    public FlowNodeInstanceFilterRequest incidentKey(Long incidentKey) {
        this.incidentKey = incidentKey;
        return this;
    }

    @Schema(name="incidentKey", description="The key of incident if field incident is true", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="incidentKey")
    public Long getIncidentKey() {
        return this.incidentKey;
    }

    public void setIncidentKey(Long incidentKey) {
        this.incidentKey = incidentKey;
    }

    public FlowNodeInstanceFilterRequest tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowNodeInstanceFilterRequest flowNodeInstanceFilterRequest = (FlowNodeInstanceFilterRequest)o;
        return Objects.equals(this.flowNodeInstanceKey, flowNodeInstanceFilterRequest.flowNodeInstanceKey) && Objects.equals(this.processInstanceKey, flowNodeInstanceFilterRequest.processInstanceKey) && Objects.equals(this.processDefinitionKey, flowNodeInstanceFilterRequest.processDefinitionKey) && Objects.equals(this.state, flowNodeInstanceFilterRequest.state) && Objects.equals(this.type, flowNodeInstanceFilterRequest.type) && Objects.equals(this.flowNodeId, flowNodeInstanceFilterRequest.flowNodeId) && Objects.equals(this.flowNodeName, flowNodeInstanceFilterRequest.flowNodeName) && Objects.equals(this.treePath, flowNodeInstanceFilterRequest.treePath) && Objects.equals(this.incident, flowNodeInstanceFilterRequest.incident) && Objects.equals(this.incidentKey, flowNodeInstanceFilterRequest.incidentKey) && Objects.equals(this.tenantId, flowNodeInstanceFilterRequest.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.flowNodeInstanceKey, this.processInstanceKey, this.processDefinitionKey, this.state, this.type, this.flowNodeId, this.flowNodeName, this.treePath, this.incident, this.incidentKey, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlowNodeInstanceFilterRequest {\n");
        sb.append("    flowNodeInstanceKey: ").append(this.toIndentedString(this.flowNodeInstanceKey)).append("\n");
        sb.append("    processInstanceKey: ").append(this.toIndentedString(this.processInstanceKey)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    flowNodeId: ").append(this.toIndentedString(this.flowNodeId)).append("\n");
        sb.append("    flowNodeName: ").append(this.toIndentedString(this.flowNodeName)).append("\n");
        sb.append("    treePath: ").append(this.toIndentedString(this.treePath)).append("\n");
        sb.append("    incident: ").append(this.toIndentedString(this.incident)).append("\n");
        sb.append("    incidentKey: ").append(this.toIndentedString(this.incidentKey)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

