/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.gateway.protocol.rest.EvaluatedDecisionInputItem;
import io.camunda.zeebe.gateway.protocol.rest.MatchedDecisionRuleItem;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="EvaluatedDecisionItem", description="List of decisions that were evaluated within the requested decision evaluation.")
public class EvaluatedDecisionItem {
    private Long decisionDefinitionKey;
    private String decisionDefinitionId;
    private String decisionDefinitionName;
    private Integer decisionDefinitionVersion;
    private String decisionDefinitionType;
    private String output;
    private String tenantId;
    @Valid
    private @Valid List<@Valid MatchedDecisionRuleItem> matchedRules = new ArrayList<MatchedDecisionRuleItem>();
    @Valid
    private @Valid List<@Valid EvaluatedDecisionInputItem> evaluatedInputs = new ArrayList<EvaluatedDecisionInputItem>();

    public EvaluatedDecisionItem decisionDefinitionKey(Long decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
        return this;
    }

    @Schema(name="decisionDefinitionKey", description="The unique key identifying the decision which was evaluate.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionKey")
    public Long getDecisionDefinitionKey() {
        return this.decisionDefinitionKey;
    }

    public void setDecisionDefinitionKey(Long decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
    }

    public EvaluatedDecisionItem decisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
        return this;
    }

    @Schema(name="decisionDefinitionId", description="The ID of the decision which was evaluated.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionId")
    public String getDecisionDefinitionId() {
        return this.decisionDefinitionId;
    }

    public void setDecisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    public EvaluatedDecisionItem decisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
        return this;
    }

    @Schema(name="decisionDefinitionName", description="The name of the decision which was evaluated.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionName")
    public String getDecisionDefinitionName() {
        return this.decisionDefinitionName;
    }

    public void setDecisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
    }

    public EvaluatedDecisionItem decisionDefinitionVersion(Integer decisionDefinitionVersion) {
        this.decisionDefinitionVersion = decisionDefinitionVersion;
        return this;
    }

    @Schema(name="decisionDefinitionVersion", description="The version of the decision which was evaluated.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionVersion")
    public Integer getDecisionDefinitionVersion() {
        return this.decisionDefinitionVersion;
    }

    public void setDecisionDefinitionVersion(Integer decisionDefinitionVersion) {
        this.decisionDefinitionVersion = decisionDefinitionVersion;
    }

    public EvaluatedDecisionItem decisionDefinitionType(String decisionDefinitionType) {
        this.decisionDefinitionType = decisionDefinitionType;
        return this;
    }

    @Schema(name="decisionDefinitionType", description="The type of the decision which was evaluated.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionType")
    public String getDecisionDefinitionType() {
        return this.decisionDefinitionType;
    }

    public void setDecisionDefinitionType(String decisionDefinitionType) {
        this.decisionDefinitionType = decisionDefinitionType;
    }

    public EvaluatedDecisionItem output(String output) {
        this.output = output;
        return this;
    }

    @Schema(name="output", description="JSON document that will instantiate the result of the decision which was evaluated. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="output")
    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public EvaluatedDecisionItem tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant ID of the evaluated decision.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public EvaluatedDecisionItem matchedRules(List<@Valid MatchedDecisionRuleItem> matchedRules) {
        this.matchedRules = matchedRules;
        return this;
    }

    public EvaluatedDecisionItem addMatchedRulesItem(MatchedDecisionRuleItem matchedRulesItem) {
        if (this.matchedRules == null) {
            this.matchedRules = new ArrayList<MatchedDecisionRuleItem>();
        }
        this.matchedRules.add(matchedRulesItem);
        return this;
    }

    @Valid
    @Schema(name="matchedRules", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="matchedRules")
    public @Valid List<@Valid MatchedDecisionRuleItem> getMatchedRules() {
        return this.matchedRules;
    }

    public void setMatchedRules(List<@Valid MatchedDecisionRuleItem> matchedRules) {
        this.matchedRules = matchedRules;
    }

    public EvaluatedDecisionItem evaluatedInputs(List<@Valid EvaluatedDecisionInputItem> evaluatedInputs) {
        this.evaluatedInputs = evaluatedInputs;
        return this;
    }

    public EvaluatedDecisionItem addEvaluatedInputsItem(EvaluatedDecisionInputItem evaluatedInputsItem) {
        if (this.evaluatedInputs == null) {
            this.evaluatedInputs = new ArrayList<EvaluatedDecisionInputItem>();
        }
        this.evaluatedInputs.add(evaluatedInputsItem);
        return this;
    }

    @Valid
    @Schema(name="evaluatedInputs", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="evaluatedInputs")
    public @Valid List<@Valid EvaluatedDecisionInputItem> getEvaluatedInputs() {
        return this.evaluatedInputs;
    }

    public void setEvaluatedInputs(List<@Valid EvaluatedDecisionInputItem> evaluatedInputs) {
        this.evaluatedInputs = evaluatedInputs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluatedDecisionItem evaluatedDecisionItem = (EvaluatedDecisionItem)o;
        return Objects.equals(this.decisionDefinitionKey, evaluatedDecisionItem.decisionDefinitionKey) && Objects.equals(this.decisionDefinitionId, evaluatedDecisionItem.decisionDefinitionId) && Objects.equals(this.decisionDefinitionName, evaluatedDecisionItem.decisionDefinitionName) && Objects.equals(this.decisionDefinitionVersion, evaluatedDecisionItem.decisionDefinitionVersion) && Objects.equals(this.decisionDefinitionType, evaluatedDecisionItem.decisionDefinitionType) && Objects.equals(this.output, evaluatedDecisionItem.output) && Objects.equals(this.tenantId, evaluatedDecisionItem.tenantId) && Objects.equals(this.matchedRules, evaluatedDecisionItem.matchedRules) && Objects.equals(this.evaluatedInputs, evaluatedDecisionItem.evaluatedInputs);
    }

    public int hashCode() {
        return Objects.hash(this.decisionDefinitionKey, this.decisionDefinitionId, this.decisionDefinitionName, this.decisionDefinitionVersion, this.decisionDefinitionType, this.output, this.tenantId, this.matchedRules, this.evaluatedInputs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EvaluatedDecisionItem {\n");
        sb.append("    decisionDefinitionKey: ").append(this.toIndentedString(this.decisionDefinitionKey)).append("\n");
        sb.append("    decisionDefinitionId: ").append(this.toIndentedString(this.decisionDefinitionId)).append("\n");
        sb.append("    decisionDefinitionName: ").append(this.toIndentedString(this.decisionDefinitionName)).append("\n");
        sb.append("    decisionDefinitionVersion: ").append(this.toIndentedString(this.decisionDefinitionVersion)).append("\n");
        sb.append("    decisionDefinitionType: ").append(this.toIndentedString(this.decisionDefinitionType)).append("\n");
        sb.append("    output: ").append(this.toIndentedString(this.output)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    matchedRules: ").append(this.toIndentedString(this.matchedRules)).append("\n");
        sb.append("    evaluatedInputs: ").append(this.toIndentedString(this.evaluatedInputs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

