/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="EvaluatedDecisionInputItem", description="The decision inputs that were evaluated within this decision evaluation.")
public class EvaluatedDecisionInputItem {
    private String inputId;
    private String inputName;
    private String inputValue;

    public EvaluatedDecisionInputItem inputId(String inputId) {
        this.inputId = inputId;
        return this;
    }

    @Schema(name="inputId", description="The ID of the evaluated decision input.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="inputId")
    public String getInputId() {
        return this.inputId;
    }

    public void setInputId(String inputId) {
        this.inputId = inputId;
    }

    public EvaluatedDecisionInputItem inputName(String inputName) {
        this.inputName = inputName;
        return this;
    }

    @Schema(name="inputName", description="The name of the evaluated decision input.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="inputName")
    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    public EvaluatedDecisionInputItem inputValue(String inputValue) {
        this.inputValue = inputValue;
        return this;
    }

    @Schema(name="inputValue", description="The value of the evaluated decision input.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="inputValue")
    public String getInputValue() {
        return this.inputValue;
    }

    public void setInputValue(String inputValue) {
        this.inputValue = inputValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluatedDecisionInputItem evaluatedDecisionInputItem = (EvaluatedDecisionInputItem)o;
        return Objects.equals(this.inputId, evaluatedDecisionInputItem.inputId) && Objects.equals(this.inputName, evaluatedDecisionInputItem.inputName) && Objects.equals(this.inputValue, evaluatedDecisionInputItem.inputValue);
    }

    public int hashCode() {
        return Objects.hash(this.inputId, this.inputName, this.inputValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EvaluatedDecisionInputItem {\n");
        sb.append("    inputId: ").append(this.toIndentedString(this.inputId)).append("\n");
        sb.append("    inputName: ").append(this.toIndentedString(this.inputName)).append("\n");
        sb.append("    inputValue: ").append(this.toIndentedString(this.inputValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

