/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.gateway.protocol.rest.EvaluatedDecisionItem;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EvaluateDecisionResponse {
    private Long decisionDefinitionKey;
    private String decisionDefinitionId;
    private String decisionDefinitionName;
    private Integer decisionDefinitionVersion;
    private String decisionRequirementsId;
    private Long decisionRequirementsKey;
    private String output;
    private String failedDecisionDefinitionId;
    private String failureMessage;
    private String tenantId;
    private Long decisionInstanceKey;
    @Valid
    private @Valid List<@Valid EvaluatedDecisionItem> evaluatedDecisions = new ArrayList<EvaluatedDecisionItem>();

    public EvaluateDecisionResponse decisionDefinitionKey(Long decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
        return this;
    }

    @Schema(name="decisionDefinitionKey", description="The unique key identifying the decision which was evaluated.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionKey")
    public Long getDecisionDefinitionKey() {
        return this.decisionDefinitionKey;
    }

    public void setDecisionDefinitionKey(Long decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
    }

    public EvaluateDecisionResponse decisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
        return this;
    }

    @Schema(name="decisionDefinitionId", description="The ID of the decision which was evaluated.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionId")
    public String getDecisionDefinitionId() {
        return this.decisionDefinitionId;
    }

    public void setDecisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    public EvaluateDecisionResponse decisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
        return this;
    }

    @Schema(name="decisionDefinitionName", description="The name of the decision which was evaluated.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionName")
    public String getDecisionDefinitionName() {
        return this.decisionDefinitionName;
    }

    public void setDecisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
    }

    public EvaluateDecisionResponse decisionDefinitionVersion(Integer decisionDefinitionVersion) {
        this.decisionDefinitionVersion = decisionDefinitionVersion;
        return this;
    }

    @Schema(name="decisionDefinitionVersion", description="The version of the decision which was evaluated.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionVersion")
    public Integer getDecisionDefinitionVersion() {
        return this.decisionDefinitionVersion;
    }

    public void setDecisionDefinitionVersion(Integer decisionDefinitionVersion) {
        this.decisionDefinitionVersion = decisionDefinitionVersion;
    }

    public EvaluateDecisionResponse decisionRequirementsId(String decisionRequirementsId) {
        this.decisionRequirementsId = decisionRequirementsId;
        return this;
    }

    @Schema(name="decisionRequirementsId", description="The ID of the decision requirements graph that the decision which was evaluated is part of.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirementsId")
    public String getDecisionRequirementsId() {
        return this.decisionRequirementsId;
    }

    public void setDecisionRequirementsId(String decisionRequirementsId) {
        this.decisionRequirementsId = decisionRequirementsId;
    }

    public EvaluateDecisionResponse decisionRequirementsKey(Long decisionRequirementsKey) {
        this.decisionRequirementsKey = decisionRequirementsKey;
        return this;
    }

    @Schema(name="decisionRequirementsKey", description="The unique key identifying the decision requirements graph that the decision which was evaluated is part of.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirementsKey")
    public Long getDecisionRequirementsKey() {
        return this.decisionRequirementsKey;
    }

    public void setDecisionRequirementsKey(Long decisionRequirementsKey) {
        this.decisionRequirementsKey = decisionRequirementsKey;
    }

    public EvaluateDecisionResponse output(String output) {
        this.output = output;
        return this;
    }

    @Schema(name="output", description="JSON document that will instantiate the result of the decision which was evaluated. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="output")
    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public EvaluateDecisionResponse failedDecisionDefinitionId(String failedDecisionDefinitionId) {
        this.failedDecisionDefinitionId = failedDecisionDefinitionId;
        return this;
    }

    @Schema(name="failedDecisionDefinitionId", description="The ID of the decision which failed during evaluation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="failedDecisionDefinitionId")
    public String getFailedDecisionDefinitionId() {
        return this.failedDecisionDefinitionId;
    }

    public void setFailedDecisionDefinitionId(String failedDecisionDefinitionId) {
        this.failedDecisionDefinitionId = failedDecisionDefinitionId;
    }

    public EvaluateDecisionResponse failureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
        return this;
    }

    @Schema(name="failureMessage", description="Message describing why the decision which was evaluated failed.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="failureMessage")
    public String getFailureMessage() {
        return this.failureMessage;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public EvaluateDecisionResponse tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant ID of the evaluated decision.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public EvaluateDecisionResponse decisionInstanceKey(Long decisionInstanceKey) {
        this.decisionInstanceKey = decisionInstanceKey;
        return this;
    }

    @Schema(name="decisionInstanceKey", description="The unique key identifying this decision evaluation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionInstanceKey")
    public Long getDecisionInstanceKey() {
        return this.decisionInstanceKey;
    }

    public void setDecisionInstanceKey(Long decisionInstanceKey) {
        this.decisionInstanceKey = decisionInstanceKey;
    }

    public EvaluateDecisionResponse evaluatedDecisions(List<@Valid EvaluatedDecisionItem> evaluatedDecisions) {
        this.evaluatedDecisions = evaluatedDecisions;
        return this;
    }

    public EvaluateDecisionResponse addEvaluatedDecisionsItem(EvaluatedDecisionItem evaluatedDecisionsItem) {
        if (this.evaluatedDecisions == null) {
            this.evaluatedDecisions = new ArrayList<EvaluatedDecisionItem>();
        }
        this.evaluatedDecisions.add(evaluatedDecisionsItem);
        return this;
    }

    @Valid
    @Schema(name="evaluatedDecisions", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="evaluatedDecisions")
    public @Valid List<@Valid EvaluatedDecisionItem> getEvaluatedDecisions() {
        return this.evaluatedDecisions;
    }

    public void setEvaluatedDecisions(List<@Valid EvaluatedDecisionItem> evaluatedDecisions) {
        this.evaluatedDecisions = evaluatedDecisions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluateDecisionResponse evaluateDecisionResponse = (EvaluateDecisionResponse)o;
        return Objects.equals(this.decisionDefinitionKey, evaluateDecisionResponse.decisionDefinitionKey) && Objects.equals(this.decisionDefinitionId, evaluateDecisionResponse.decisionDefinitionId) && Objects.equals(this.decisionDefinitionName, evaluateDecisionResponse.decisionDefinitionName) && Objects.equals(this.decisionDefinitionVersion, evaluateDecisionResponse.decisionDefinitionVersion) && Objects.equals(this.decisionRequirementsId, evaluateDecisionResponse.decisionRequirementsId) && Objects.equals(this.decisionRequirementsKey, evaluateDecisionResponse.decisionRequirementsKey) && Objects.equals(this.output, evaluateDecisionResponse.output) && Objects.equals(this.failedDecisionDefinitionId, evaluateDecisionResponse.failedDecisionDefinitionId) && Objects.equals(this.failureMessage, evaluateDecisionResponse.failureMessage) && Objects.equals(this.tenantId, evaluateDecisionResponse.tenantId) && Objects.equals(this.decisionInstanceKey, evaluateDecisionResponse.decisionInstanceKey) && Objects.equals(this.evaluatedDecisions, evaluateDecisionResponse.evaluatedDecisions);
    }

    public int hashCode() {
        return Objects.hash(this.decisionDefinitionKey, this.decisionDefinitionId, this.decisionDefinitionName, this.decisionDefinitionVersion, this.decisionRequirementsId, this.decisionRequirementsKey, this.output, this.failedDecisionDefinitionId, this.failureMessage, this.tenantId, this.decisionInstanceKey, this.evaluatedDecisions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EvaluateDecisionResponse {\n");
        sb.append("    decisionDefinitionKey: ").append(this.toIndentedString(this.decisionDefinitionKey)).append("\n");
        sb.append("    decisionDefinitionId: ").append(this.toIndentedString(this.decisionDefinitionId)).append("\n");
        sb.append("    decisionDefinitionName: ").append(this.toIndentedString(this.decisionDefinitionName)).append("\n");
        sb.append("    decisionDefinitionVersion: ").append(this.toIndentedString(this.decisionDefinitionVersion)).append("\n");
        sb.append("    decisionRequirementsId: ").append(this.toIndentedString(this.decisionRequirementsId)).append("\n");
        sb.append("    decisionRequirementsKey: ").append(this.toIndentedString(this.decisionRequirementsKey)).append("\n");
        sb.append("    output: ").append(this.toIndentedString(this.output)).append("\n");
        sb.append("    failedDecisionDefinitionId: ").append(this.toIndentedString(this.failedDecisionDefinitionId)).append("\n");
        sb.append("    failureMessage: ").append(this.toIndentedString(this.failureMessage)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    decisionInstanceKey: ").append(this.toIndentedString(this.decisionInstanceKey)).append("\n");
        sb.append("    evaluatedDecisions: ").append(this.toIndentedString(this.evaluatedDecisions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

