/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.gateway.protocol.rest.DocumentMetadata;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DocumentReference {
    private DocumentTypeEnum documentType;
    private String storeId;
    private String documentId;
    private DocumentMetadata metadata;

    public DocumentReference documentType(DocumentTypeEnum documentType) {
        this.documentType = documentType;
        return this;
    }

    @Schema(name="documentType", description="Document discriminator. Always set to \"camunda\".", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="documentType")
    public DocumentTypeEnum getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(DocumentTypeEnum documentType) {
        this.documentType = documentType;
    }

    public DocumentReference storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @Schema(name="storeId", description="The ID of the document store.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="storeId")
    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public DocumentReference documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @Schema(name="documentId", description="The ID of the document.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="documentId")
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public DocumentReference metadata(DocumentMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Valid
    @Schema(name="metadata", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="metadata")
    public DocumentMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(DocumentMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentReference documentReference = (DocumentReference)o;
        return Objects.equals((Object)this.documentType, (Object)documentReference.documentType) && Objects.equals(this.storeId, documentReference.storeId) && Objects.equals(this.documentId, documentReference.documentId) && Objects.equals(this.metadata, documentReference.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.documentType, this.storeId, this.documentId, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentReference {\n");
        sb.append("    documentType: ").append(this.toIndentedString((Object)this.documentType)).append("\n");
        sb.append("    storeId: ").append(this.toIndentedString(this.storeId)).append("\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DocumentTypeEnum {
        CAMUNDA("camunda");

        private String value;

        private DocumentTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DocumentTypeEnum fromValue(String value) {
            for (DocumentTypeEnum b : DocumentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

