/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DocumentMetadata {
    private String contentType;
    private String fileName;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String expiresAt;
    private Long size;
    private Map<String, Object> additionalProperties;

    public DocumentMetadata contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Schema(name="contentType", description="The content type of the document.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="contentType")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public DocumentMetadata fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Schema(name="fileName", description="The name of the file.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="fileName")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public DocumentMetadata expiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Valid
    @Schema(name="expiresAt", description="The date and time when the document expires.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="expiresAt")
    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public DocumentMetadata size(Long size) {
        this.size = size;
        return this;
    }

    @Schema(name="size", description="The size of the document in bytes.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="size")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    @JsonAnySetter
    public DocumentMetadata putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentMetadata documentMetadata = (DocumentMetadata)o;
        return Objects.equals(this.contentType, documentMetadata.contentType) && Objects.equals(this.fileName, documentMetadata.fileName) && Objects.equals(this.expiresAt, documentMetadata.expiresAt) && Objects.equals(this.size, documentMetadata.size) && Objects.equals(this.additionalProperties, documentMetadata.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.fileName, this.expiresAt, this.size, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentMetadata {\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

