/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DocumentLinkRequest {
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String expiresAt = null;

    public DocumentLinkRequest expiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Valid
    @Schema(name="expiresAt", description="The date and time when the link expires.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="expiresAt")
    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentLinkRequest documentLinkRequest = (DocumentLinkRequest)o;
        return Objects.equals(this.expiresAt, documentLinkRequest.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.expiresAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentLinkRequest {\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

