/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentMetadata;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeploymentResponse {
    private Long deploymentKey;
    @Valid
    private @Valid List<@Valid DeploymentMetadata> deployments = new ArrayList<DeploymentMetadata>();
    private String tenantId;

    public DeploymentResponse deploymentKey(Long deploymentKey) {
        this.deploymentKey = deploymentKey;
        return this;
    }

    @Schema(name="deploymentKey", description="The unique key identifying the deployment.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="deploymentKey")
    public Long getDeploymentKey() {
        return this.deploymentKey;
    }

    public void setDeploymentKey(Long deploymentKey) {
        this.deploymentKey = deploymentKey;
    }

    public DeploymentResponse deployments(List<@Valid DeploymentMetadata> deployments) {
        this.deployments = deployments;
        return this;
    }

    public DeploymentResponse addDeploymentsItem(DeploymentMetadata deploymentsItem) {
        if (this.deployments == null) {
            this.deployments = new ArrayList<DeploymentMetadata>();
        }
        this.deployments.add(deploymentsItem);
        return this;
    }

    @Valid
    @Schema(name="deployments", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="deployments")
    public @Valid List<@Valid DeploymentMetadata> getDeployments() {
        return this.deployments;
    }

    public void setDeployments(List<@Valid DeploymentMetadata> deployments) {
        this.deployments = deployments;
    }

    public DeploymentResponse tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentResponse deploymentResponse = (DeploymentResponse)o;
        return Objects.equals(this.deploymentKey, deploymentResponse.deploymentKey) && Objects.equals(this.deployments, deploymentResponse.deployments) && Objects.equals(this.tenantId, deploymentResponse.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.deploymentKey, this.deployments, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeploymentResponse {\n");
        sb.append("    deploymentKey: ").append(this.toIndentedString(this.deploymentKey)).append("\n");
        sb.append("    deployments: ").append(this.toIndentedString(this.deployments)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

