/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeploymentProcess {
    private String processDefinitionId;
    private Integer processDefinitionVersion;
    private Long processDefinitionKey;
    private String resourceName;
    private String tenantId;

    public DeploymentProcess processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Schema(name="processDefinitionId", description="The bpmn process ID, as parsed during deployment, together with the version forms a unique identifier for a specific process definition. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionId")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public DeploymentProcess processDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
        return this;
    }

    @Schema(name="processDefinitionVersion", description="The assigned process version.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionVersion")
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public DeploymentProcess processDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Schema(name="processDefinitionKey", description="The assigned key, which acts as a unique identifier for this process.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionKey")
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public DeploymentProcess resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    @Schema(name="resourceName", description="The resource name from which this process was parsed.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="resourceName")
    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public DeploymentProcess tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant ID of the deployed process.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentProcess deploymentProcess = (DeploymentProcess)o;
        return Objects.equals(this.processDefinitionId, deploymentProcess.processDefinitionId) && Objects.equals(this.processDefinitionVersion, deploymentProcess.processDefinitionVersion) && Objects.equals(this.processDefinitionKey, deploymentProcess.processDefinitionKey) && Objects.equals(this.resourceName, deploymentProcess.resourceName) && Objects.equals(this.tenantId, deploymentProcess.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.processDefinitionId, this.processDefinitionVersion, this.processDefinitionKey, this.resourceName, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeploymentProcess {\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionVersion: ").append(this.toIndentedString(this.processDefinitionVersion)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    resourceName: ").append(this.toIndentedString(this.resourceName)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

