/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentDecision;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentDecisionRequirements;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentForm;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentProcess;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeploymentMetadata {
    private DeploymentProcess processDefinition;
    private DeploymentDecision decisionDefinition;
    private DeploymentDecisionRequirements decisionRequirements;
    private DeploymentForm form;

    public DeploymentMetadata processDefinition(DeploymentProcess processDefinition) {
        this.processDefinition = processDefinition;
        return this;
    }

    @Valid
    @Schema(name="processDefinition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinition")
    public DeploymentProcess getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(DeploymentProcess processDefinition) {
        this.processDefinition = processDefinition;
    }

    public DeploymentMetadata decisionDefinition(DeploymentDecision decisionDefinition) {
        this.decisionDefinition = decisionDefinition;
        return this;
    }

    @Valid
    @Schema(name="decisionDefinition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinition")
    public DeploymentDecision getDecisionDefinition() {
        return this.decisionDefinition;
    }

    public void setDecisionDefinition(DeploymentDecision decisionDefinition) {
        this.decisionDefinition = decisionDefinition;
    }

    public DeploymentMetadata decisionRequirements(DeploymentDecisionRequirements decisionRequirements) {
        this.decisionRequirements = decisionRequirements;
        return this;
    }

    @Valid
    @Schema(name="decisionRequirements", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirements")
    public DeploymentDecisionRequirements getDecisionRequirements() {
        return this.decisionRequirements;
    }

    public void setDecisionRequirements(DeploymentDecisionRequirements decisionRequirements) {
        this.decisionRequirements = decisionRequirements;
    }

    public DeploymentMetadata form(DeploymentForm form) {
        this.form = form;
        return this;
    }

    @Valid
    @Schema(name="form", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="form")
    public DeploymentForm getForm() {
        return this.form;
    }

    public void setForm(DeploymentForm form) {
        this.form = form;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentMetadata deploymentMetadata = (DeploymentMetadata)o;
        return Objects.equals(this.processDefinition, deploymentMetadata.processDefinition) && Objects.equals(this.decisionDefinition, deploymentMetadata.decisionDefinition) && Objects.equals(this.decisionRequirements, deploymentMetadata.decisionRequirements) && Objects.equals(this.form, deploymentMetadata.form);
    }

    public int hashCode() {
        return Objects.hash(this.processDefinition, this.decisionDefinition, this.decisionRequirements, this.form);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeploymentMetadata {\n");
        sb.append("    processDefinition: ").append(this.toIndentedString(this.processDefinition)).append("\n");
        sb.append("    decisionDefinition: ").append(this.toIndentedString(this.decisionDefinition)).append("\n");
        sb.append("    decisionRequirements: ").append(this.toIndentedString(this.decisionRequirements)).append("\n");
        sb.append("    form: ").append(this.toIndentedString(this.form)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

