/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeploymentForm {
    private String formId;
    private Integer version;
    private Long formKey;
    private String resourceName;
    private String tenantId;

    public DeploymentForm formId(String formId) {
        this.formId = formId;
        return this;
    }

    @Schema(name="formId", description="The form ID, as parsed during deployment, together with the version forms a unique identifier for a specific form. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="formId")
    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public DeploymentForm version(Integer version) {
        this.version = version;
        return this;
    }

    @Schema(name="version", description="The assigned form version.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public DeploymentForm formKey(Long formKey) {
        this.formKey = formKey;
        return this;
    }

    @Schema(name="formKey", description="The assigned key, which acts as a unique identifier for this form.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="formKey")
    public Long getFormKey() {
        return this.formKey;
    }

    public void setFormKey(Long formKey) {
        this.formKey = formKey;
    }

    public DeploymentForm resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    @Schema(name="resourceName", description="The resource name from which this form was parsed.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="resourceName")
    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public DeploymentForm tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant ID of the deployed form.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentForm deploymentForm = (DeploymentForm)o;
        return Objects.equals(this.formId, deploymentForm.formId) && Objects.equals(this.version, deploymentForm.version) && Objects.equals(this.formKey, deploymentForm.formKey) && Objects.equals(this.resourceName, deploymentForm.resourceName) && Objects.equals(this.tenantId, deploymentForm.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.formId, this.version, this.formKey, this.resourceName, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeploymentForm {\n");
        sb.append("    formId: ").append(this.toIndentedString(this.formId)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    formKey: ").append(this.toIndentedString(this.formKey)).append("\n");
        sb.append("    resourceName: ").append(this.toIndentedString(this.resourceName)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

