/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeploymentDecisionRequirements {
    private String decisionRequirementsId;
    private Integer version;
    private String decisionRequirementsName;
    private String tenantId;
    private Long decisionRequirementsKey;
    private String resourceName;

    public DeploymentDecisionRequirements decisionRequirementsId(String decisionRequirementsId) {
        this.decisionRequirementsId = decisionRequirementsId;
        return this;
    }

    @Schema(name="decisionRequirementsId", description="The dmn decision requirements ID, as parsed during deployment; together with the versions forms a unique identifier for a specific decision. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirementsId")
    public String getDecisionRequirementsId() {
        return this.decisionRequirementsId;
    }

    public void setDecisionRequirementsId(String decisionRequirementsId) {
        this.decisionRequirementsId = decisionRequirementsId;
    }

    public DeploymentDecisionRequirements version(Integer version) {
        this.version = version;
        return this;
    }

    @Schema(name="version", description="The assigned decision requirements version.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public DeploymentDecisionRequirements decisionRequirementsName(String decisionRequirementsName) {
        this.decisionRequirementsName = decisionRequirementsName;
        return this;
    }

    @Schema(name="decisionRequirementsName", description="The DMN name of the decision requirements, as parsed during deployment.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirementsName")
    public String getDecisionRequirementsName() {
        return this.decisionRequirementsName;
    }

    public void setDecisionRequirementsName(String decisionRequirementsName) {
        this.decisionRequirementsName = decisionRequirementsName;
    }

    public DeploymentDecisionRequirements tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant ID of the deployed decision requirements.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public DeploymentDecisionRequirements decisionRequirementsKey(Long decisionRequirementsKey) {
        this.decisionRequirementsKey = decisionRequirementsKey;
        return this;
    }

    @Schema(name="decisionRequirementsKey", description="The assigned decision requirements key, which acts as a unique identifier for this decision requirements. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirementsKey")
    public Long getDecisionRequirementsKey() {
        return this.decisionRequirementsKey;
    }

    public void setDecisionRequirementsKey(Long decisionRequirementsKey) {
        this.decisionRequirementsKey = decisionRequirementsKey;
    }

    public DeploymentDecisionRequirements resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    @Schema(name="resourceName", description="The resource name from which this decision requirements was parsed.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="resourceName")
    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentDecisionRequirements deploymentDecisionRequirements = (DeploymentDecisionRequirements)o;
        return Objects.equals(this.decisionRequirementsId, deploymentDecisionRequirements.decisionRequirementsId) && Objects.equals(this.version, deploymentDecisionRequirements.version) && Objects.equals(this.decisionRequirementsName, deploymentDecisionRequirements.decisionRequirementsName) && Objects.equals(this.tenantId, deploymentDecisionRequirements.tenantId) && Objects.equals(this.decisionRequirementsKey, deploymentDecisionRequirements.decisionRequirementsKey) && Objects.equals(this.resourceName, deploymentDecisionRequirements.resourceName);
    }

    public int hashCode() {
        return Objects.hash(this.decisionRequirementsId, this.version, this.decisionRequirementsName, this.tenantId, this.decisionRequirementsKey, this.resourceName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeploymentDecisionRequirements {\n");
        sb.append("    decisionRequirementsId: ").append(this.toIndentedString(this.decisionRequirementsId)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    decisionRequirementsName: ").append(this.toIndentedString(this.decisionRequirementsName)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    decisionRequirementsKey: ").append(this.toIndentedString(this.decisionRequirementsKey)).append("\n");
        sb.append("    resourceName: ").append(this.toIndentedString(this.resourceName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

