/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeploymentDecision {
    private String decisionDefinitionId;
    private Integer version;
    private Long decisionDefinitionKey;
    private String name;
    private String tenantId;
    private String decisionRequirementsId;
    private Long decisionRequirementsKey;

    public DeploymentDecision decisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
        return this;
    }

    @Schema(name="decisionDefinitionId", description="The dmn decision ID, as parsed during deployment, together with the version forms a unique identifier for a specific decision. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionId")
    public String getDecisionDefinitionId() {
        return this.decisionDefinitionId;
    }

    public void setDecisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    public DeploymentDecision version(Integer version) {
        this.version = version;
        return this;
    }

    @Schema(name="version", description="The assigned decision version.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public DeploymentDecision decisionDefinitionKey(Long decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
        return this;
    }

    @Schema(name="decisionDefinitionKey", description="The assigned decision key, which acts as a unique identifier for this decision. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionKey")
    public Long getDecisionDefinitionKey() {
        return this.decisionDefinitionKey;
    }

    public void setDecisionDefinitionKey(Long decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
    }

    public DeploymentDecision name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="The DMN name of the decision, as parsed during deployment.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeploymentDecision tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant ID of the deployed decision.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public DeploymentDecision decisionRequirementsId(String decisionRequirementsId) {
        this.decisionRequirementsId = decisionRequirementsId;
        return this;
    }

    @Schema(name="decisionRequirementsId", description="The dmn ID of the decision requirements graph that this decision is part of, as parsed during deployment. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirementsId")
    public String getDecisionRequirementsId() {
        return this.decisionRequirementsId;
    }

    public void setDecisionRequirementsId(String decisionRequirementsId) {
        this.decisionRequirementsId = decisionRequirementsId;
    }

    public DeploymentDecision decisionRequirementsKey(Long decisionRequirementsKey) {
        this.decisionRequirementsKey = decisionRequirementsKey;
        return this;
    }

    @Schema(name="decisionRequirementsKey", description="The assigned key of the decision requirements graph that this decision is part of. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirementsKey")
    public Long getDecisionRequirementsKey() {
        return this.decisionRequirementsKey;
    }

    public void setDecisionRequirementsKey(Long decisionRequirementsKey) {
        this.decisionRequirementsKey = decisionRequirementsKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentDecision deploymentDecision = (DeploymentDecision)o;
        return Objects.equals(this.decisionDefinitionId, deploymentDecision.decisionDefinitionId) && Objects.equals(this.version, deploymentDecision.version) && Objects.equals(this.decisionDefinitionKey, deploymentDecision.decisionDefinitionKey) && Objects.equals(this.name, deploymentDecision.name) && Objects.equals(this.tenantId, deploymentDecision.tenantId) && Objects.equals(this.decisionRequirementsId, deploymentDecision.decisionRequirementsId) && Objects.equals(this.decisionRequirementsKey, deploymentDecision.decisionRequirementsKey);
    }

    public int hashCode() {
        return Objects.hash(this.decisionDefinitionId, this.version, this.decisionDefinitionKey, this.name, this.tenantId, this.decisionRequirementsId, this.decisionRequirementsKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeploymentDecision {\n");
        sb.append("    decisionDefinitionId: ").append(this.toIndentedString(this.decisionDefinitionId)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    decisionDefinitionKey: ").append(this.toIndentedString(this.decisionDefinitionKey)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    decisionRequirementsId: ").append(this.toIndentedString(this.decisionRequirementsId)).append("\n");
        sb.append("    decisionRequirementsKey: ").append(this.toIndentedString(this.decisionRequirementsKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

