/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DecisionRequirementsItem {
    private Long decisionRequirementsKey;
    private String decisionRequirementsName;
    private Integer version;
    private String decisionRequirementsId;
    private String resourceName;
    private String tenantId;

    public DecisionRequirementsItem decisionRequirementsKey(Long decisionRequirementsKey) {
        this.decisionRequirementsKey = decisionRequirementsKey;
        return this;
    }

    @Schema(name="decisionRequirementsKey", description="The assigned key, which acts as a unique identifier for this decision requirements.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirementsKey")
    public Long getDecisionRequirementsKey() {
        return this.decisionRequirementsKey;
    }

    public void setDecisionRequirementsKey(Long decisionRequirementsKey) {
        this.decisionRequirementsKey = decisionRequirementsKey;
    }

    public DecisionRequirementsItem decisionRequirementsName(String decisionRequirementsName) {
        this.decisionRequirementsName = decisionRequirementsName;
        return this;
    }

    @Schema(name="decisionRequirementsName", description="The DMN name of the decision requirements.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirementsName")
    public String getDecisionRequirementsName() {
        return this.decisionRequirementsName;
    }

    public void setDecisionRequirementsName(String decisionRequirementsName) {
        this.decisionRequirementsName = decisionRequirementsName;
    }

    public DecisionRequirementsItem version(Integer version) {
        this.version = version;
        return this;
    }

    @Schema(name="version", description="The assigned version of the decision requirements.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public DecisionRequirementsItem decisionRequirementsId(String decisionRequirementsId) {
        this.decisionRequirementsId = decisionRequirementsId;
        return this;
    }

    @Schema(name="decisionRequirementsId", description="the DMN id of the decision requirements.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirementsId")
    public String getDecisionRequirementsId() {
        return this.decisionRequirementsId;
    }

    public void setDecisionRequirementsId(String decisionRequirementsId) {
        this.decisionRequirementsId = decisionRequirementsId;
    }

    public DecisionRequirementsItem resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    @Schema(name="resourceName", description="The name of the resource from which this decision requirements was parsed.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="resourceName")
    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public DecisionRequirementsItem tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant ID of the decision requirements.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionRequirementsItem decisionRequirementsItem = (DecisionRequirementsItem)o;
        return Objects.equals(this.decisionRequirementsKey, decisionRequirementsItem.decisionRequirementsKey) && Objects.equals(this.decisionRequirementsName, decisionRequirementsItem.decisionRequirementsName) && Objects.equals(this.version, decisionRequirementsItem.version) && Objects.equals(this.decisionRequirementsId, decisionRequirementsItem.decisionRequirementsId) && Objects.equals(this.resourceName, decisionRequirementsItem.resourceName) && Objects.equals(this.tenantId, decisionRequirementsItem.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.decisionRequirementsKey, this.decisionRequirementsName, this.version, this.decisionRequirementsId, this.resourceName, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecisionRequirementsItem {\n");
        sb.append("    decisionRequirementsKey: ").append(this.toIndentedString(this.decisionRequirementsKey)).append("\n");
        sb.append("    decisionRequirementsName: ").append(this.toIndentedString(this.decisionRequirementsName)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    decisionRequirementsId: ").append(this.toIndentedString(this.decisionRequirementsId)).append("\n");
        sb.append("    resourceName: ").append(this.toIndentedString(this.resourceName)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

