/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DecisionRequirementsFilterRequest {
    private Long decisionRequirementsKey;
    private String decisionRequirementsName;
    private Integer version;
    private String decisionRequirementsId;
    private String tenantId;

    public DecisionRequirementsFilterRequest decisionRequirementsKey(Long decisionRequirementsKey) {
        this.decisionRequirementsKey = decisionRequirementsKey;
        return this;
    }

    @Schema(name="decisionRequirementsKey", description="The assigned key, which acts as a unique identifier for this decision requirements.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirementsKey")
    public Long getDecisionRequirementsKey() {
        return this.decisionRequirementsKey;
    }

    public void setDecisionRequirementsKey(Long decisionRequirementsKey) {
        this.decisionRequirementsKey = decisionRequirementsKey;
    }

    public DecisionRequirementsFilterRequest decisionRequirementsName(String decisionRequirementsName) {
        this.decisionRequirementsName = decisionRequirementsName;
        return this;
    }

    @Schema(name="decisionRequirementsName", description="The DMN name of the decision requirements.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirementsName")
    public String getDecisionRequirementsName() {
        return this.decisionRequirementsName;
    }

    public void setDecisionRequirementsName(String decisionRequirementsName) {
        this.decisionRequirementsName = decisionRequirementsName;
    }

    public DecisionRequirementsFilterRequest version(Integer version) {
        this.version = version;
        return this;
    }

    @Schema(name="version", description="The assigned version of the decision requirements.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public DecisionRequirementsFilterRequest decisionRequirementsId(String decisionRequirementsId) {
        this.decisionRequirementsId = decisionRequirementsId;
        return this;
    }

    @Schema(name="decisionRequirementsId", description="the DMN id of the decision requirements.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirementsId")
    public String getDecisionRequirementsId() {
        return this.decisionRequirementsId;
    }

    public void setDecisionRequirementsId(String decisionRequirementsId) {
        this.decisionRequirementsId = decisionRequirementsId;
    }

    public DecisionRequirementsFilterRequest tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant ID of the decision requirements.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionRequirementsFilterRequest decisionRequirementsFilterRequest = (DecisionRequirementsFilterRequest)o;
        return Objects.equals(this.decisionRequirementsKey, decisionRequirementsFilterRequest.decisionRequirementsKey) && Objects.equals(this.decisionRequirementsName, decisionRequirementsFilterRequest.decisionRequirementsName) && Objects.equals(this.version, decisionRequirementsFilterRequest.version) && Objects.equals(this.decisionRequirementsId, decisionRequirementsFilterRequest.decisionRequirementsId) && Objects.equals(this.tenantId, decisionRequirementsFilterRequest.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.decisionRequirementsKey, this.decisionRequirementsName, this.version, this.decisionRequirementsId, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecisionRequirementsFilterRequest {\n");
        sb.append("    decisionRequirementsKey: ").append(this.toIndentedString(this.decisionRequirementsKey)).append("\n");
        sb.append("    decisionRequirementsName: ").append(this.toIndentedString(this.decisionRequirementsName)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    decisionRequirementsId: ").append(this.toIndentedString(this.decisionRequirementsId)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

