/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.gateway.protocol.rest.DecisionInstanceFilterRequest;
import io.camunda.zeebe.gateway.protocol.rest.SearchQueryPageRequest;
import io.camunda.zeebe.gateway.protocol.rest.SearchQuerySortRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DecisionInstanceSearchQueryRequest {
    private DecisionInstanceFilterRequest filter;
    @Valid
    private List<SearchQuerySortRequest> sort = new ArrayList<SearchQuerySortRequest>();
    private SearchQueryPageRequest page;

    public DecisionInstanceSearchQueryRequest filter(DecisionInstanceFilterRequest filter) {
        this.filter = filter;
        return this;
    }

    @Valid
    @Schema(name="filter", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="filter")
    public DecisionInstanceFilterRequest getFilter() {
        return this.filter;
    }

    public void setFilter(DecisionInstanceFilterRequest filter) {
        this.filter = filter;
    }

    public DecisionInstanceSearchQueryRequest sort(List<SearchQuerySortRequest> sort) {
        this.sort = sort;
        return this;
    }

    public DecisionInstanceSearchQueryRequest addSortItem(SearchQuerySortRequest sortItem) {
        if (this.sort == null) {
            this.sort = new ArrayList<SearchQuerySortRequest>();
        }
        this.sort.add(sortItem);
        return this;
    }

    @Valid
    @Schema(name="sort", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="sort")
    public List<SearchQuerySortRequest> getSort() {
        return this.sort;
    }

    public void setSort(List<SearchQuerySortRequest> sort) {
        this.sort = sort;
    }

    public DecisionInstanceSearchQueryRequest page(SearchQueryPageRequest page) {
        this.page = page;
        return this;
    }

    @Valid
    @Schema(name="page", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="page")
    public SearchQueryPageRequest getPage() {
        return this.page;
    }

    public void setPage(SearchQueryPageRequest page) {
        this.page = page;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionInstanceSearchQueryRequest decisionInstanceSearchQueryRequest = (DecisionInstanceSearchQueryRequest)o;
        return Objects.equals(this.filter, decisionInstanceSearchQueryRequest.filter) && Objects.equals(this.sort, decisionInstanceSearchQueryRequest.sort) && Objects.equals(this.page, decisionInstanceSearchQueryRequest.page);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort, this.page);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecisionInstanceSearchQueryRequest {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

