/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.gateway.protocol.rest.DecisionInstanceStateEnum;
import io.camunda.zeebe.gateway.protocol.rest.DecisionInstanceTypeEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DecisionInstanceItem {
    private Long key;
    private DecisionInstanceStateEnum state;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String evaluationDate;
    private String evaluationFailure;
    private Long processDefinitionKey;
    private Long processInstanceKey;
    private Long decisionDefinitionKey;
    private String decisionDefinitionId;
    private String decisionDefinitionName;
    private Integer decisionDefinitionVersion;
    private DecisionInstanceTypeEnum decisionDefinitionType;
    private String result;
    private String tenantId;

    public DecisionInstanceItem key(Long key) {
        this.key = key;
        return this;
    }

    @Schema(name="key", description="The key of the decision instance.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="key")
    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public DecisionInstanceItem state(DecisionInstanceStateEnum state) {
        this.state = state;
        return this;
    }

    @Valid
    @Schema(name="state", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="state")
    public DecisionInstanceStateEnum getState() {
        return this.state;
    }

    public void setState(DecisionInstanceStateEnum state) {
        this.state = state;
    }

    public DecisionInstanceItem evaluationDate(String evaluationDate) {
        this.evaluationDate = evaluationDate;
        return this;
    }

    @Valid
    @Schema(name="evaluationDate", description="The evaluation date of the decision instance.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="evaluationDate")
    public String getEvaluationDate() {
        return this.evaluationDate;
    }

    public void setEvaluationDate(String evaluationDate) {
        this.evaluationDate = evaluationDate;
    }

    public DecisionInstanceItem evaluationFailure(String evaluationFailure) {
        this.evaluationFailure = evaluationFailure;
        return this;
    }

    @Schema(name="evaluationFailure", description="The evaluation failure of the decision instance.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="evaluationFailure")
    public String getEvaluationFailure() {
        return this.evaluationFailure;
    }

    public void setEvaluationFailure(String evaluationFailure) {
        this.evaluationFailure = evaluationFailure;
    }

    public DecisionInstanceItem processDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Schema(name="processDefinitionKey", description="The key of the process definition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionKey")
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public DecisionInstanceItem processInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @Schema(name="processInstanceKey", description="The key of the process instance.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processInstanceKey")
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public DecisionInstanceItem decisionDefinitionKey(Long decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
        return this;
    }

    @Schema(name="decisionDefinitionKey", description="The key of the decision.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionKey")
    public Long getDecisionDefinitionKey() {
        return this.decisionDefinitionKey;
    }

    public void setDecisionDefinitionKey(Long decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
    }

    public DecisionInstanceItem decisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
        return this;
    }

    @Schema(name="decisionDefinitionId", description="The ID of the DMN decision.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionId")
    public String getDecisionDefinitionId() {
        return this.decisionDefinitionId;
    }

    public void setDecisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    public DecisionInstanceItem decisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
        return this;
    }

    @Schema(name="decisionDefinitionName", description="The name of the DMN decision.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionName")
    public String getDecisionDefinitionName() {
        return this.decisionDefinitionName;
    }

    public void setDecisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
    }

    public DecisionInstanceItem decisionDefinitionVersion(Integer decisionDefinitionVersion) {
        this.decisionDefinitionVersion = decisionDefinitionVersion;
        return this;
    }

    @Schema(name="decisionDefinitionVersion", description="The version of the decision.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionVersion")
    public Integer getDecisionDefinitionVersion() {
        return this.decisionDefinitionVersion;
    }

    public void setDecisionDefinitionVersion(Integer decisionDefinitionVersion) {
        this.decisionDefinitionVersion = decisionDefinitionVersion;
    }

    public DecisionInstanceItem decisionDefinitionType(DecisionInstanceTypeEnum decisionDefinitionType) {
        this.decisionDefinitionType = decisionDefinitionType;
        return this;
    }

    @Valid
    @Schema(name="decisionDefinitionType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionType")
    public DecisionInstanceTypeEnum getDecisionDefinitionType() {
        return this.decisionDefinitionType;
    }

    public void setDecisionDefinitionType(DecisionInstanceTypeEnum decisionDefinitionType) {
        this.decisionDefinitionType = decisionDefinitionType;
    }

    public DecisionInstanceItem result(String result) {
        this.result = result;
        return this;
    }

    @Schema(name="result", description="The result of the decision instance.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="result")
    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public DecisionInstanceItem tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant ID of the decision instance.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionInstanceItem decisionInstanceItem = (DecisionInstanceItem)o;
        return Objects.equals(this.key, decisionInstanceItem.key) && Objects.equals((Object)this.state, (Object)decisionInstanceItem.state) && Objects.equals(this.evaluationDate, decisionInstanceItem.evaluationDate) && Objects.equals(this.evaluationFailure, decisionInstanceItem.evaluationFailure) && Objects.equals(this.processDefinitionKey, decisionInstanceItem.processDefinitionKey) && Objects.equals(this.processInstanceKey, decisionInstanceItem.processInstanceKey) && Objects.equals(this.decisionDefinitionKey, decisionInstanceItem.decisionDefinitionKey) && Objects.equals(this.decisionDefinitionId, decisionInstanceItem.decisionDefinitionId) && Objects.equals(this.decisionDefinitionName, decisionInstanceItem.decisionDefinitionName) && Objects.equals(this.decisionDefinitionVersion, decisionInstanceItem.decisionDefinitionVersion) && Objects.equals((Object)this.decisionDefinitionType, (Object)decisionInstanceItem.decisionDefinitionType) && Objects.equals(this.result, decisionInstanceItem.result) && Objects.equals(this.tenantId, decisionInstanceItem.tenantId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.state, this.evaluationDate, this.evaluationFailure, this.processDefinitionKey, this.processInstanceKey, this.decisionDefinitionKey, this.decisionDefinitionId, this.decisionDefinitionName, this.decisionDefinitionVersion, this.decisionDefinitionType, this.result, this.tenantId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecisionInstanceItem {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    evaluationDate: ").append(this.toIndentedString(this.evaluationDate)).append("\n");
        sb.append("    evaluationFailure: ").append(this.toIndentedString(this.evaluationFailure)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processInstanceKey: ").append(this.toIndentedString(this.processInstanceKey)).append("\n");
        sb.append("    decisionDefinitionKey: ").append(this.toIndentedString(this.decisionDefinitionKey)).append("\n");
        sb.append("    decisionDefinitionId: ").append(this.toIndentedString(this.decisionDefinitionId)).append("\n");
        sb.append("    decisionDefinitionName: ").append(this.toIndentedString(this.decisionDefinitionName)).append("\n");
        sb.append("    decisionDefinitionVersion: ").append(this.toIndentedString(this.decisionDefinitionVersion)).append("\n");
        sb.append("    decisionDefinitionType: ").append(this.toIndentedString((Object)this.decisionDefinitionType)).append("\n");
        sb.append("    result: ").append(this.toIndentedString(this.result)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

