/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.gateway.protocol.rest.DecisionInstanceStateEnum;
import io.camunda.zeebe.gateway.protocol.rest.DecisionInstanceTypeEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DecisionInstanceFilterRequest {
    private Long key;
    private DecisionInstanceStateEnum state;
    private String evaluationFailure;
    private Long processDefinitionKey;
    private Long processInstanceKey;
    private Long decisionDefinitionKey;
    private String decisionDefinitionId;
    private String decisionDefinitionName;
    private Integer decisionDefinitionVersion;
    private DecisionInstanceTypeEnum decisionDefinitionType;
    private String tenantId;

    public DecisionInstanceFilterRequest key(Long key) {
        this.key = key;
        return this;
    }

    @Schema(name="key", description="The key of the decision instance.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="key")
    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public DecisionInstanceFilterRequest state(DecisionInstanceStateEnum state) {
        this.state = state;
        return this;
    }

    @Valid
    @Schema(name="state", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="state")
    public DecisionInstanceStateEnum getState() {
        return this.state;
    }

    public void setState(DecisionInstanceStateEnum state) {
        this.state = state;
    }

    public DecisionInstanceFilterRequest evaluationFailure(String evaluationFailure) {
        this.evaluationFailure = evaluationFailure;
        return this;
    }

    @Schema(name="evaluationFailure", description="The evaluation failure of the decision instance.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="evaluationFailure")
    public String getEvaluationFailure() {
        return this.evaluationFailure;
    }

    public void setEvaluationFailure(String evaluationFailure) {
        this.evaluationFailure = evaluationFailure;
    }

    public DecisionInstanceFilterRequest processDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Schema(name="processDefinitionKey", description="The key of the process definition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionKey")
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public DecisionInstanceFilterRequest processInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @Schema(name="processInstanceKey", description="The key of the process instance.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processInstanceKey")
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public DecisionInstanceFilterRequest decisionDefinitionKey(Long decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
        return this;
    }

    @Schema(name="decisionDefinitionKey", description="The key of the decision.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionKey")
    public Long getDecisionDefinitionKey() {
        return this.decisionDefinitionKey;
    }

    public void setDecisionDefinitionKey(Long decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
    }

    public DecisionInstanceFilterRequest decisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
        return this;
    }

    @Schema(name="decisionDefinitionId", description="The ID of the DMN decision.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionId")
    public String getDecisionDefinitionId() {
        return this.decisionDefinitionId;
    }

    public void setDecisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    public DecisionInstanceFilterRequest decisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
        return this;
    }

    @Schema(name="decisionDefinitionName", description="The name of the DMN decision.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionName")
    public String getDecisionDefinitionName() {
        return this.decisionDefinitionName;
    }

    public void setDecisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
    }

    public DecisionInstanceFilterRequest decisionDefinitionVersion(Integer decisionDefinitionVersion) {
        this.decisionDefinitionVersion = decisionDefinitionVersion;
        return this;
    }

    @Schema(name="decisionDefinitionVersion", description="The version of the decision.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionVersion")
    public Integer getDecisionDefinitionVersion() {
        return this.decisionDefinitionVersion;
    }

    public void setDecisionDefinitionVersion(Integer decisionDefinitionVersion) {
        this.decisionDefinitionVersion = decisionDefinitionVersion;
    }

    public DecisionInstanceFilterRequest decisionDefinitionType(DecisionInstanceTypeEnum decisionDefinitionType) {
        this.decisionDefinitionType = decisionDefinitionType;
        return this;
    }

    @Valid
    @Schema(name="decisionDefinitionType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionType")
    public DecisionInstanceTypeEnum getDecisionDefinitionType() {
        return this.decisionDefinitionType;
    }

    public void setDecisionDefinitionType(DecisionInstanceTypeEnum decisionDefinitionType) {
        this.decisionDefinitionType = decisionDefinitionType;
    }

    public DecisionInstanceFilterRequest tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant ID of the decision instance.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionInstanceFilterRequest decisionInstanceFilterRequest = (DecisionInstanceFilterRequest)o;
        return Objects.equals(this.key, decisionInstanceFilterRequest.key) && Objects.equals((Object)this.state, (Object)decisionInstanceFilterRequest.state) && Objects.equals(this.evaluationFailure, decisionInstanceFilterRequest.evaluationFailure) && Objects.equals(this.processDefinitionKey, decisionInstanceFilterRequest.processDefinitionKey) && Objects.equals(this.processInstanceKey, decisionInstanceFilterRequest.processInstanceKey) && Objects.equals(this.decisionDefinitionKey, decisionInstanceFilterRequest.decisionDefinitionKey) && Objects.equals(this.decisionDefinitionId, decisionInstanceFilterRequest.decisionDefinitionId) && Objects.equals(this.decisionDefinitionName, decisionInstanceFilterRequest.decisionDefinitionName) && Objects.equals(this.decisionDefinitionVersion, decisionInstanceFilterRequest.decisionDefinitionVersion) && Objects.equals((Object)this.decisionDefinitionType, (Object)decisionInstanceFilterRequest.decisionDefinitionType) && Objects.equals(this.tenantId, decisionInstanceFilterRequest.tenantId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.state, this.evaluationFailure, this.processDefinitionKey, this.processInstanceKey, this.decisionDefinitionKey, this.decisionDefinitionId, this.decisionDefinitionName, this.decisionDefinitionVersion, this.decisionDefinitionType, this.tenantId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecisionInstanceFilterRequest {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    evaluationFailure: ").append(this.toIndentedString(this.evaluationFailure)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processInstanceKey: ").append(this.toIndentedString(this.processInstanceKey)).append("\n");
        sb.append("    decisionDefinitionKey: ").append(this.toIndentedString(this.decisionDefinitionKey)).append("\n");
        sb.append("    decisionDefinitionId: ").append(this.toIndentedString(this.decisionDefinitionId)).append("\n");
        sb.append("    decisionDefinitionName: ").append(this.toIndentedString(this.decisionDefinitionName)).append("\n");
        sb.append("    decisionDefinitionVersion: ").append(this.toIndentedString(this.decisionDefinitionVersion)).append("\n");
        sb.append("    decisionDefinitionType: ").append(this.toIndentedString((Object)this.decisionDefinitionType)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

