/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DecisionDefinitionItem {
    private Long decisionDefinitionKey;
    private String decisionDefinitionId;
    private String decisionDefinitionName;
    private Integer version;
    private String decisionRequirementsId;
    private Long decisionRequirementsKey;
    private String tenantId;

    public DecisionDefinitionItem decisionDefinitionKey(Long decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
        return this;
    }

    @Schema(name="decisionDefinitionKey", description="The assigned key, which acts as a unique identifier for this decision definition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionKey")
    public Long getDecisionDefinitionKey() {
        return this.decisionDefinitionKey;
    }

    public void setDecisionDefinitionKey(Long decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
    }

    public DecisionDefinitionItem decisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
        return this;
    }

    @Schema(name="decisionDefinitionId", description="The DMN id of the decision definition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionId")
    public String getDecisionDefinitionId() {
        return this.decisionDefinitionId;
    }

    public void setDecisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    public DecisionDefinitionItem decisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
        return this;
    }

    @Schema(name="decisionDefinitionName", description="The DMN name of the decision definition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionDefinitionName")
    public String getDecisionDefinitionName() {
        return this.decisionDefinitionName;
    }

    public void setDecisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
    }

    public DecisionDefinitionItem version(Integer version) {
        this.version = version;
        return this;
    }

    @Schema(name="version", description="The assigned version of the decision definition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public DecisionDefinitionItem decisionRequirementsId(String decisionRequirementsId) {
        this.decisionRequirementsId = decisionRequirementsId;
        return this;
    }

    @Schema(name="decisionRequirementsId", description="the DMN id of the decision requirements graph that the decision definition is part of.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirementsId")
    public String getDecisionRequirementsId() {
        return this.decisionRequirementsId;
    }

    public void setDecisionRequirementsId(String decisionRequirementsId) {
        this.decisionRequirementsId = decisionRequirementsId;
    }

    public DecisionDefinitionItem decisionRequirementsKey(Long decisionRequirementsKey) {
        this.decisionRequirementsKey = decisionRequirementsKey;
        return this;
    }

    @Schema(name="decisionRequirementsKey", description="The assigned key of the decision requirements graph that the decision definition is part of.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="decisionRequirementsKey")
    public Long getDecisionRequirementsKey() {
        return this.decisionRequirementsKey;
    }

    public void setDecisionRequirementsKey(Long decisionRequirementsKey) {
        this.decisionRequirementsKey = decisionRequirementsKey;
    }

    public DecisionDefinitionItem tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant id of the decision definition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionDefinitionItem decisionDefinitionItem = (DecisionDefinitionItem)o;
        return Objects.equals(this.decisionDefinitionKey, decisionDefinitionItem.decisionDefinitionKey) && Objects.equals(this.decisionDefinitionId, decisionDefinitionItem.decisionDefinitionId) && Objects.equals(this.decisionDefinitionName, decisionDefinitionItem.decisionDefinitionName) && Objects.equals(this.version, decisionDefinitionItem.version) && Objects.equals(this.decisionRequirementsId, decisionDefinitionItem.decisionRequirementsId) && Objects.equals(this.decisionRequirementsKey, decisionDefinitionItem.decisionRequirementsKey) && Objects.equals(this.tenantId, decisionDefinitionItem.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.decisionDefinitionKey, this.decisionDefinitionId, this.decisionDefinitionName, this.version, this.decisionRequirementsId, this.decisionRequirementsKey, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecisionDefinitionItem {\n");
        sb.append("    decisionDefinitionKey: ").append(this.toIndentedString(this.decisionDefinitionKey)).append("\n");
        sb.append("    decisionDefinitionId: ").append(this.toIndentedString(this.decisionDefinitionId)).append("\n");
        sb.append("    decisionDefinitionName: ").append(this.toIndentedString(this.decisionDefinitionName)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    decisionRequirementsId: ").append(this.toIndentedString(this.decisionRequirementsId)).append("\n");
        sb.append("    decisionRequirementsKey: ").append(this.toIndentedString(this.decisionRequirementsKey)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

