/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.gateway.protocol.rest.ProcessInstanceCreationStartInstruction;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateProcessInstanceRequest {
    private Long processDefinitionKey;
    private String processDefinitionId;
    private Integer processDefinitionVersion = -1;
    @Valid
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String tenantId;
    private Long operationReference;
    @Valid
    private @Valid List<@Valid ProcessInstanceCreationStartInstruction> startInstructions = new ArrayList<ProcessInstanceCreationStartInstruction>();
    private Boolean awaitCompletion = false;
    @Valid
    private List<String> fetchVariables = new ArrayList<String>();
    private Long requestTimeout;

    public CreateProcessInstanceRequest processDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Schema(name="processDefinitionKey", description="The unique key identifying the process definition, e.g. returned for a process in the deploy resources endpoint. Cannot be used together with processDefinitionId. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionKey")
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public CreateProcessInstanceRequest processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Schema(name="processDefinitionId", description="The BPMN process ID of the process definition to start an instance of. Cannot be used together with processDefinitionKey. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionId")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public CreateProcessInstanceRequest processDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
        return this;
    }

    @Schema(name="processDefinitionVersion", description="The version of the process. Only considered when a processDefinitionId is provided. By default, the latest version of the process is used. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionVersion")
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public CreateProcessInstanceRequest variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public CreateProcessInstanceRequest putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Schema(name="variables", description="JSON object that will instantiate the variables for the root variable scope of the process instance. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="variables")
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public CreateProcessInstanceRequest tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant ID of the process definition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public CreateProcessInstanceRequest operationReference(Long operationReference) {
        this.operationReference = operationReference;
        return this;
    }

    @Min(value=1L)
    @Schema(name="operationReference", description="A reference key chosen by the user that will be part of all records resulting from this operation. Must be >0 if provided. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="operationReference")
    public @Min(value=1L) Long getOperationReference() {
        return this.operationReference;
    }

    public void setOperationReference(Long operationReference) {
        this.operationReference = operationReference;
    }

    public CreateProcessInstanceRequest startInstructions(List<@Valid ProcessInstanceCreationStartInstruction> startInstructions) {
        this.startInstructions = startInstructions;
        return this;
    }

    public CreateProcessInstanceRequest addStartInstructionsItem(ProcessInstanceCreationStartInstruction startInstructionsItem) {
        if (this.startInstructions == null) {
            this.startInstructions = new ArrayList<ProcessInstanceCreationStartInstruction>();
        }
        this.startInstructions.add(startInstructionsItem);
        return this;
    }

    @Valid
    @Schema(name="startInstructions", description="List of start instructions. By default, the process instance will start at the start event. If provided, the process instance will apply start instructions after it has been created. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="startInstructions")
    public @Valid List<@Valid ProcessInstanceCreationStartInstruction> getStartInstructions() {
        return this.startInstructions;
    }

    public void setStartInstructions(List<@Valid ProcessInstanceCreationStartInstruction> startInstructions) {
        this.startInstructions = startInstructions;
    }

    public CreateProcessInstanceRequest awaitCompletion(Boolean awaitCompletion) {
        this.awaitCompletion = awaitCompletion;
        return this;
    }

    @Schema(name="awaitCompletion", description="Wait for the process instance to complete. If the process instance completion does not occur within the requestTimeout, the request will be closed. Disabled by default. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="awaitCompletion")
    public Boolean getAwaitCompletion() {
        return this.awaitCompletion;
    }

    public void setAwaitCompletion(Boolean awaitCompletion) {
        this.awaitCompletion = awaitCompletion;
    }

    public CreateProcessInstanceRequest fetchVariables(List<String> fetchVariables) {
        this.fetchVariables = fetchVariables;
        return this;
    }

    public CreateProcessInstanceRequest addFetchVariablesItem(String fetchVariablesItem) {
        if (this.fetchVariables == null) {
            this.fetchVariables = new ArrayList<String>();
        }
        this.fetchVariables.add(fetchVariablesItem);
        return this;
    }

    @Schema(name="fetchVariables", description="List of variables names to be included in the response. If empty, all visible variables in the root scope will be returned. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="fetchVariables")
    public List<String> getFetchVariables() {
        return this.fetchVariables;
    }

    public void setFetchVariables(List<String> fetchVariables) {
        this.fetchVariables = fetchVariables;
    }

    public CreateProcessInstanceRequest requestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Schema(name="requestTimeout", description="Timeout (in ms) the request waits for the process to complete. By default or when set to 0, the generic request timeout configured in the cluster is applied. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="requestTimeout")
    public Long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateProcessInstanceRequest createProcessInstanceRequest = (CreateProcessInstanceRequest)o;
        return Objects.equals(this.processDefinitionKey, createProcessInstanceRequest.processDefinitionKey) && Objects.equals(this.processDefinitionId, createProcessInstanceRequest.processDefinitionId) && Objects.equals(this.processDefinitionVersion, createProcessInstanceRequest.processDefinitionVersion) && Objects.equals(this.variables, createProcessInstanceRequest.variables) && Objects.equals(this.tenantId, createProcessInstanceRequest.tenantId) && Objects.equals(this.operationReference, createProcessInstanceRequest.operationReference) && Objects.equals(this.startInstructions, createProcessInstanceRequest.startInstructions) && Objects.equals(this.awaitCompletion, createProcessInstanceRequest.awaitCompletion) && Objects.equals(this.fetchVariables, createProcessInstanceRequest.fetchVariables) && Objects.equals(this.requestTimeout, createProcessInstanceRequest.requestTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.processDefinitionKey, this.processDefinitionId, this.processDefinitionVersion, this.variables, this.tenantId, this.operationReference, this.startInstructions, this.awaitCompletion, this.fetchVariables, this.requestTimeout);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateProcessInstanceRequest {\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionVersion: ").append(this.toIndentedString(this.processDefinitionVersion)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    operationReference: ").append(this.toIndentedString(this.operationReference)).append("\n");
        sb.append("    startInstructions: ").append(this.toIndentedString(this.startInstructions)).append("\n");
        sb.append("    awaitCompletion: ").append(this.toIndentedString(this.awaitCompletion)).append("\n");
        sb.append("    fetchVariables: ").append(this.toIndentedString(this.fetchVariables)).append("\n");
        sb.append("    requestTimeout: ").append(this.toIndentedString(this.requestTimeout)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

