/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ClockPinRequest {
    private Long timestamp;

    public ClockPinRequest() {
    }

    public ClockPinRequest(Long timestamp) {
        this.timestamp = timestamp;
    }

    public ClockPinRequest timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @NotNull
    @Schema(name="timestamp", description="The exact time in epoch milliseconds to which the clock should be pinned.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClockPinRequest clockPinRequest = (ClockPinRequest)o;
        return Objects.equals(this.timestamp, clockPinRequest.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClockPinRequest {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

