/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CancelProcessInstanceRequest {
    private Long operationReference;

    public CancelProcessInstanceRequest operationReference(Long operationReference) {
        this.operationReference = operationReference;
        return this;
    }

    @Min(value=1L)
    @Schema(name="operationReference", description="A reference key chosen by the user that will be part of all records resulting from this operation. Must be > 0 if provided. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="operationReference")
    public @Min(value=1L) Long getOperationReference() {
        return this.operationReference;
    }

    public void setOperationReference(Long operationReference) {
        this.operationReference = operationReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelProcessInstanceRequest cancelProcessInstanceRequest = (CancelProcessInstanceRequest)o;
        return Objects.equals(this.operationReference, cancelProcessInstanceRequest.operationReference);
    }

    public int hashCode() {
        return Objects.hash(this.operationReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CancelProcessInstanceRequest {\n");
        sb.append("    operationReference: ").append(this.toIndentedString(this.operationReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

