/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.gateway.protocol.rest.Partition;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="BrokerInfo", description="Provides information on a broker node.")
public class BrokerInfo {
    private Integer nodeId;
    private String host;
    private Integer port;
    @Valid
    private @Valid List<@Valid Partition> partitions = new ArrayList<Partition>();
    private String version;

    public BrokerInfo nodeId(Integer nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @Schema(name="nodeId", description="The unique (within a cluster) node ID for the broker.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="nodeId")
    public Integer getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(Integer nodeId) {
        this.nodeId = nodeId;
    }

    public BrokerInfo host(String host) {
        this.host = host;
        return this;
    }

    @Schema(name="host", description="The hostname for reaching the broker.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public BrokerInfo port(Integer port) {
        this.port = port;
        return this;
    }

    @Schema(name="port", description="The port for reaching the broker.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public BrokerInfo partitions(List<@Valid Partition> partitions) {
        this.partitions = partitions;
        return this;
    }

    public BrokerInfo addPartitionsItem(Partition partitionsItem) {
        if (this.partitions == null) {
            this.partitions = new ArrayList<Partition>();
        }
        this.partitions.add(partitionsItem);
        return this;
    }

    @Valid
    @Schema(name="partitions", description="A list of partitions managed or replicated on this broker.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="partitions")
    public @Valid List<@Valid Partition> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(List<@Valid Partition> partitions) {
        this.partitions = partitions;
    }

    public BrokerInfo version(String version) {
        this.version = version;
        return this;
    }

    @Schema(name="version", description="The broker version.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerInfo brokerInfo = (BrokerInfo)o;
        return Objects.equals(this.nodeId, brokerInfo.nodeId) && Objects.equals(this.host, brokerInfo.host) && Objects.equals(this.port, brokerInfo.port) && Objects.equals(this.partitions, brokerInfo.partitions) && Objects.equals(this.version, brokerInfo.version);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.host, this.port, this.partitions, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrokerInfo {\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.nodeId)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    partitions: ").append(this.toIndentedString(this.partitions)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

