/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeName(value="AuthorizationPatchRequest_permissions_inner")
public class AuthorizationPatchRequestPermissionsInner {
    private PermissionTypeEnum permissionType;
    @Valid
    private List<String> resourceIds = new ArrayList<String>();

    public AuthorizationPatchRequestPermissionsInner permissionType(PermissionTypeEnum permissionType) {
        this.permissionType = permissionType;
        return this;
    }

    @Schema(name="permissionType", description="Specifies the type of permissions.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="permissionType")
    public PermissionTypeEnum getPermissionType() {
        return this.permissionType;
    }

    public void setPermissionType(PermissionTypeEnum permissionType) {
        this.permissionType = permissionType;
    }

    public AuthorizationPatchRequestPermissionsInner resourceIds(List<String> resourceIds) {
        this.resourceIds = resourceIds;
        return this;
    }

    public AuthorizationPatchRequestPermissionsInner addResourceIdsItem(String resourceIdsItem) {
        if (this.resourceIds == null) {
            this.resourceIds = new ArrayList<String>();
        }
        this.resourceIds.add(resourceIdsItem);
        return this;
    }

    @Schema(name="resourceIds", description="A list of resource IDs the permission relates to.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="resourceIds")
    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(List<String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationPatchRequestPermissionsInner authorizationPatchRequestPermissionsInner = (AuthorizationPatchRequestPermissionsInner)o;
        return Objects.equals((Object)this.permissionType, (Object)authorizationPatchRequestPermissionsInner.permissionType) && Objects.equals(this.resourceIds, authorizationPatchRequestPermissionsInner.resourceIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.permissionType, this.resourceIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationPatchRequestPermissionsInner {\n");
        sb.append("    permissionType: ").append(this.toIndentedString((Object)this.permissionType)).append("\n");
        sb.append("    resourceIds: ").append(this.toIndentedString(this.resourceIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PermissionTypeEnum {
        CREATE("CREATE"),
        READ("READ"),
        UPDATE("UPDATE"),
        DELETE("DELETE");

        private String value;

        private PermissionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PermissionTypeEnum fromValue(String value) {
            for (PermissionTypeEnum b : PermissionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

