/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.gateway.protocol.rest.AuthorizationPatchRequestPermissionsInner;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AuthorizationPatchRequest {
    private ActionEnum action;
    private ResourceTypeEnum resourceType;
    @Valid
    private @Valid List<@Valid AuthorizationPatchRequestPermissionsInner> permissions = new ArrayList<AuthorizationPatchRequestPermissionsInner>();

    public AuthorizationPatchRequest action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @Schema(name="action", description="Indicates if permissions should be added or removed.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public AuthorizationPatchRequest resourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Schema(name="resourceType", description="The type of resource to add/remove perissions to/from.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="resourceType")
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public AuthorizationPatchRequest permissions(List<@Valid AuthorizationPatchRequestPermissionsInner> permissions) {
        this.permissions = permissions;
        return this;
    }

    public AuthorizationPatchRequest addPermissionsItem(AuthorizationPatchRequestPermissionsInner permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<AuthorizationPatchRequestPermissionsInner>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @Valid
    @Schema(name="permissions", description="The permissions to add/remove.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="permissions")
    public @Valid List<@Valid AuthorizationPatchRequestPermissionsInner> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<@Valid AuthorizationPatchRequestPermissionsInner> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationPatchRequest authorizationPatchRequest = (AuthorizationPatchRequest)o;
        return Objects.equals((Object)this.action, (Object)authorizationPatchRequest.action) && Objects.equals((Object)this.resourceType, (Object)authorizationPatchRequest.resourceType) && Objects.equals(this.permissions, authorizationPatchRequest.permissions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.resourceType, this.permissions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationPatchRequest {\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ActionEnum {
        ADD("ADD"),
        REMOVE("REMOVE");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String value) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ResourceTypeEnum {
        AUTHORIZATION("AUTHORIZATION"),
        MESSAGE("MESSAGE"),
        JOB("JOB"),
        APPLICATION("APPLICATION"),
        TENANT("TENANT"),
        DEPLOYMENT("DEPLOYMENT"),
        PROCESS_DEFINITION("PROCESS_DEFINITION"),
        USER_TASK("USER_TASK"),
        DECISION_REQUIREMENTS_DEFINITION("DECISION_REQUIREMENTS_DEFINITION"),
        DECISION_DEFINITION("DECISION_DEFINITION"),
        USER_GROUP("USER_GROUP"),
        USER("USER"),
        ROLE("ROLE");

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResourceTypeEnum fromValue(String value) {
            for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

