/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ActivatedJob {
    private Long jobKey;
    private String type;
    private Long processInstanceKey;
    private String processDefinitionId;
    private Integer processDefinitionVersion;
    private Long processDefinitionKey;
    private String elementId;
    private Long elementInstanceKey;
    @Valid
    private Map<String, Object> customHeaders = new HashMap<String, Object>();
    private String worker;
    private Integer retries;
    private Long deadline;
    @Valid
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String tenantId;

    public ActivatedJob jobKey(Long jobKey) {
        this.jobKey = jobKey;
        return this;
    }

    @Schema(name="jobKey", description="the key, a unique identifier for the job", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="jobKey")
    public Long getJobKey() {
        return this.jobKey;
    }

    public void setJobKey(Long jobKey) {
        this.jobKey = jobKey;
    }

    public ActivatedJob type(String type) {
        this.type = type;
        return this;
    }

    @Schema(name="type", description="the type of the job (should match what was requested)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ActivatedJob processInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @Schema(name="processInstanceKey", description="the job's process instance key", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processInstanceKey")
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public ActivatedJob processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Schema(name="processDefinitionId", description="the bpmn process ID of the job's process definition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionId")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public ActivatedJob processDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
        return this;
    }

    @Schema(name="processDefinitionVersion", description="the version of the job's process definition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionVersion")
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public ActivatedJob processDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Schema(name="processDefinitionKey", description="the key of the job's process definition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionKey")
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public ActivatedJob elementId(String elementId) {
        this.elementId = elementId;
        return this;
    }

    @Schema(name="elementId", description="the associated task element ID", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="elementId")
    public String getElementId() {
        return this.elementId;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public ActivatedJob elementInstanceKey(Long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
        return this;
    }

    @Schema(name="elementInstanceKey", description="the unique key identifying the associated task, unique within the scope of the process instance ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="elementInstanceKey")
    public Long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(Long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public ActivatedJob customHeaders(Map<String, Object> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    public ActivatedJob putCustomHeadersItem(String key, Object customHeadersItem) {
        if (this.customHeaders == null) {
            this.customHeaders = new HashMap<String, Object>();
        }
        this.customHeaders.put(key, customHeadersItem);
        return this;
    }

    @Schema(name="customHeaders", description="a set of custom headers defined during modelling; returned as a serialized JSON document", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="customHeaders")
    public Map<String, Object> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, Object> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public ActivatedJob worker(String worker) {
        this.worker = worker;
        return this;
    }

    @Schema(name="worker", description="the name of the worker which activated this job", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="worker")
    public String getWorker() {
        return this.worker;
    }

    public void setWorker(String worker) {
        this.worker = worker;
    }

    public ActivatedJob retries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @Schema(name="retries", description="the amount of retries left to this job (should always be positive)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="retries")
    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public ActivatedJob deadline(Long deadline) {
        this.deadline = deadline;
        return this;
    }

    @Schema(name="deadline", description="when the job can be activated again, sent as a UNIX epoch timestamp", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="deadline")
    public Long getDeadline() {
        return this.deadline;
    }

    public void setDeadline(Long deadline) {
        this.deadline = deadline;
    }

    public ActivatedJob variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public ActivatedJob putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Schema(name="variables", description="All variables visible to the task scope, computed at activation time", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="variables")
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public ActivatedJob tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The ID of the tenant that owns the job", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivatedJob activatedJob = (ActivatedJob)o;
        return Objects.equals(this.jobKey, activatedJob.jobKey) && Objects.equals(this.type, activatedJob.type) && Objects.equals(this.processInstanceKey, activatedJob.processInstanceKey) && Objects.equals(this.processDefinitionId, activatedJob.processDefinitionId) && Objects.equals(this.processDefinitionVersion, activatedJob.processDefinitionVersion) && Objects.equals(this.processDefinitionKey, activatedJob.processDefinitionKey) && Objects.equals(this.elementId, activatedJob.elementId) && Objects.equals(this.elementInstanceKey, activatedJob.elementInstanceKey) && Objects.equals(this.customHeaders, activatedJob.customHeaders) && Objects.equals(this.worker, activatedJob.worker) && Objects.equals(this.retries, activatedJob.retries) && Objects.equals(this.deadline, activatedJob.deadline) && Objects.equals(this.variables, activatedJob.variables) && Objects.equals(this.tenantId, activatedJob.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.jobKey, this.type, this.processInstanceKey, this.processDefinitionId, this.processDefinitionVersion, this.processDefinitionKey, this.elementId, this.elementInstanceKey, this.customHeaders, this.worker, this.retries, this.deadline, this.variables, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivatedJob {\n");
        sb.append("    jobKey: ").append(this.toIndentedString(this.jobKey)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    processInstanceKey: ").append(this.toIndentedString(this.processInstanceKey)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionVersion: ").append(this.toIndentedString(this.processDefinitionVersion)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    elementId: ").append(this.toIndentedString(this.elementId)).append("\n");
        sb.append("    elementInstanceKey: ").append(this.toIndentedString(this.elementInstanceKey)).append("\n");
        sb.append("    customHeaders: ").append(this.toIndentedString(this.customHeaders)).append("\n");
        sb.append("    worker: ").append(this.toIndentedString(this.worker)).append("\n");
        sb.append("    retries: ").append(this.toIndentedString(this.retries)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

