package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.gateway.protocol.rest.Changeset;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * UserTaskUpdateRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class UserTaskUpdateRequest {

  private Changeset changeset = null;

  private String action = null;

  public UserTaskUpdateRequest changeset(Changeset changeset) {
    this.changeset = changeset;
    return this;
  }

  /**
   * Get changeset
   * @return changeset
   */
  @Valid 
  @Schema(name = "changeset", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("changeset")
  public Changeset getChangeset() {
    return changeset;
  }

  public void setChangeset(Changeset changeset) {
    this.changeset = changeset;
  }

  public UserTaskUpdateRequest action(String action) {
    this.action = action;
    return this;
  }

  /**
   * A custom action value that will be accessible from user task events resulting from this endpoint invocation. If not provided, it will default to \"update\". 
   * @return action
   */
  
  @Schema(name = "action", description = "A custom action value that will be accessible from user task events resulting from this endpoint invocation. If not provided, it will default to \"update\". ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("action")
  public String getAction() {
    return action;
  }

  public void setAction(String action) {
    this.action = action;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserTaskUpdateRequest userTaskUpdateRequest = (UserTaskUpdateRequest) o;
    return Objects.equals(this.changeset, userTaskUpdateRequest.changeset) &&
        Objects.equals(this.action, userTaskUpdateRequest.action);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeset, action);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserTaskUpdateRequest {\n");
    sb.append("    changeset: ").append(toIndentedString(changeset)).append("\n");
    sb.append("    action: ").append(toIndentedString(action)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

