package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * UserTaskItem
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class UserTaskItem {

  private Long key;

  private String state;

  private String assignee;

  private String elementId;

  private Long elementInstanceKey;

  @Valid
  private List<String> candidateGroup = new ArrayList<>();

  @Valid
  private List<String> candidateUser = new ArrayList<>();

  private String processDefinitionId;

  private Long processDefinitionKey;

  private Long processInstanceKey;

  private Long formKey;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private String creationDate;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private String completionDate;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private String followUpDate;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private String dueDate;

  private String tenantIds;

  private String externalFormReference;

  private Integer processDefinitionVersion;

  @Valid
  private Map<String, String> customHeaders = new HashMap<>();

  private Integer priority = 50;

  public UserTaskItem key(Long key) {
    this.key = key;
    return this;
  }

  /**
   * Get key
   * @return key
   */
  
  @Schema(name = "key", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("key")
  public Long getKey() {
    return key;
  }

  public void setKey(Long key) {
    this.key = key;
  }

  public UserTaskItem state(String state) {
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
   */
  
  @Schema(name = "state", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("state")
  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public UserTaskItem assignee(String assignee) {
    this.assignee = assignee;
    return this;
  }

  /**
   * Get assignee
   * @return assignee
   */
  
  @Schema(name = "assignee", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("assignee")
  public String getAssignee() {
    return assignee;
  }

  public void setAssignee(String assignee) {
    this.assignee = assignee;
  }

  public UserTaskItem elementId(String elementId) {
    this.elementId = elementId;
    return this;
  }

  /**
   * Get elementId
   * @return elementId
   */
  
  @Schema(name = "elementId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("elementId")
  public String getElementId() {
    return elementId;
  }

  public void setElementId(String elementId) {
    this.elementId = elementId;
  }

  public UserTaskItem elementInstanceKey(Long elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
    return this;
  }

  /**
   * Get elementInstanceKey
   * @return elementInstanceKey
   */
  
  @Schema(name = "elementInstanceKey", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("elementInstanceKey")
  public Long getElementInstanceKey() {
    return elementInstanceKey;
  }

  public void setElementInstanceKey(Long elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
  }

  public UserTaskItem candidateGroup(List<String> candidateGroup) {
    this.candidateGroup = candidateGroup;
    return this;
  }

  public UserTaskItem addCandidateGroupItem(String candidateGroupItem) {
    if (this.candidateGroup == null) {
      this.candidateGroup = new ArrayList<>();
    }
    this.candidateGroup.add(candidateGroupItem);
    return this;
  }

  /**
   * Get candidateGroup
   * @return candidateGroup
   */
  
  @Schema(name = "candidateGroup", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("candidateGroup")
  public List<String> getCandidateGroup() {
    return candidateGroup;
  }

  public void setCandidateGroup(List<String> candidateGroup) {
    this.candidateGroup = candidateGroup;
  }

  public UserTaskItem candidateUser(List<String> candidateUser) {
    this.candidateUser = candidateUser;
    return this;
  }

  public UserTaskItem addCandidateUserItem(String candidateUserItem) {
    if (this.candidateUser == null) {
      this.candidateUser = new ArrayList<>();
    }
    this.candidateUser.add(candidateUserItem);
    return this;
  }

  /**
   * Get candidateUser
   * @return candidateUser
   */
  
  @Schema(name = "candidateUser", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("candidateUser")
  public List<String> getCandidateUser() {
    return candidateUser;
  }

  public void setCandidateUser(List<String> candidateUser) {
    this.candidateUser = candidateUser;
  }

  public UserTaskItem processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * Get processDefinitionId
   * @return processDefinitionId
   */
  
  @Schema(name = "processDefinitionId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionId")
  public String getProcessDefinitionId() {
    return processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public UserTaskItem processDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * Get processDefinitionKey
   * @return processDefinitionKey
   */
  
  @Schema(name = "processDefinitionKey", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionKey")
  public Long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  public void setProcessDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public UserTaskItem processInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * Get processInstanceKey
   * @return processInstanceKey
   */
  
  @Schema(name = "processInstanceKey", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processInstanceKey")
  public Long getProcessInstanceKey() {
    return processInstanceKey;
  }

  public void setProcessInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public UserTaskItem formKey(Long formKey) {
    this.formKey = formKey;
    return this;
  }

  /**
   * Get formKey
   * @return formKey
   */
  
  @Schema(name = "formKey", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("formKey")
  public Long getFormKey() {
    return formKey;
  }

  public void setFormKey(Long formKey) {
    this.formKey = formKey;
  }

  public UserTaskItem creationDate(String creationDate) {
    this.creationDate = creationDate;
    return this;
  }

  /**
   * Get creationDate
   * @return creationDate
   */
  @Valid 
  @Schema(name = "creationDate", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("creationDate")
  public String getCreationDate() {
    return creationDate;
  }

  public void setCreationDate(String creationDate) {
    this.creationDate = creationDate;
  }

  public UserTaskItem completionDate(String completionDate) {
    this.completionDate = completionDate;
    return this;
  }

  /**
   * Get completionDate
   * @return completionDate
   */
  @Valid 
  @Schema(name = "completionDate", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("completionDate")
  public String getCompletionDate() {
    return completionDate;
  }

  public void setCompletionDate(String completionDate) {
    this.completionDate = completionDate;
  }

  public UserTaskItem followUpDate(String followUpDate) {
    this.followUpDate = followUpDate;
    return this;
  }

  /**
   * Get followUpDate
   * @return followUpDate
   */
  @Valid 
  @Schema(name = "followUpDate", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("followUpDate")
  public String getFollowUpDate() {
    return followUpDate;
  }

  public void setFollowUpDate(String followUpDate) {
    this.followUpDate = followUpDate;
  }

  public UserTaskItem dueDate(String dueDate) {
    this.dueDate = dueDate;
    return this;
  }

  /**
   * Get dueDate
   * @return dueDate
   */
  @Valid 
  @Schema(name = "dueDate", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("dueDate")
  public String getDueDate() {
    return dueDate;
  }

  public void setDueDate(String dueDate) {
    this.dueDate = dueDate;
  }

  public UserTaskItem tenantIds(String tenantIds) {
    this.tenantIds = tenantIds;
    return this;
  }

  /**
   * Get tenantIds
   * @return tenantIds
   */
  
  @Schema(name = "tenantIds", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantIds")
  public String getTenantIds() {
    return tenantIds;
  }

  public void setTenantIds(String tenantIds) {
    this.tenantIds = tenantIds;
  }

  public UserTaskItem externalFormReference(String externalFormReference) {
    this.externalFormReference = externalFormReference;
    return this;
  }

  /**
   * Get externalFormReference
   * @return externalFormReference
   */
  
  @Schema(name = "externalFormReference", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("externalFormReference")
  public String getExternalFormReference() {
    return externalFormReference;
  }

  public void setExternalFormReference(String externalFormReference) {
    this.externalFormReference = externalFormReference;
  }

  public UserTaskItem processDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * Get processDefinitionVersion
   * @return processDefinitionVersion
   */
  
  @Schema(name = "processDefinitionVersion", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionVersion")
  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }

  public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public UserTaskItem customHeaders(Map<String, String> customHeaders) {
    this.customHeaders = customHeaders;
    return this;
  }

  public UserTaskItem putCustomHeadersItem(String key, String customHeadersItem) {
    if (this.customHeaders == null) {
      this.customHeaders = new HashMap<>();
    }
    this.customHeaders.put(key, customHeadersItem);
    return this;
  }

  /**
   * Get customHeaders
   * @return customHeaders
   */
  
  @Schema(name = "customHeaders", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("customHeaders")
  public Map<String, String> getCustomHeaders() {
    return customHeaders;
  }

  public void setCustomHeaders(Map<String, String> customHeaders) {
    this.customHeaders = customHeaders;
  }

  public UserTaskItem priority(Integer priority) {
    this.priority = priority;
    return this;
  }

  /**
   * The priority of a user task. The higher the value the higher the priority.
   * minimum: 0
   * maximum: 100
   * @return priority
   */
  @Min(0) @Max(100) 
  @Schema(name = "priority", description = "The priority of a user task. The higher the value the higher the priority.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("priority")
  public Integer getPriority() {
    return priority;
  }

  public void setPriority(Integer priority) {
    this.priority = priority;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserTaskItem userTaskItem = (UserTaskItem) o;
    return Objects.equals(this.key, userTaskItem.key) &&
        Objects.equals(this.state, userTaskItem.state) &&
        Objects.equals(this.assignee, userTaskItem.assignee) &&
        Objects.equals(this.elementId, userTaskItem.elementId) &&
        Objects.equals(this.elementInstanceKey, userTaskItem.elementInstanceKey) &&
        Objects.equals(this.candidateGroup, userTaskItem.candidateGroup) &&
        Objects.equals(this.candidateUser, userTaskItem.candidateUser) &&
        Objects.equals(this.processDefinitionId, userTaskItem.processDefinitionId) &&
        Objects.equals(this.processDefinitionKey, userTaskItem.processDefinitionKey) &&
        Objects.equals(this.processInstanceKey, userTaskItem.processInstanceKey) &&
        Objects.equals(this.formKey, userTaskItem.formKey) &&
        Objects.equals(this.creationDate, userTaskItem.creationDate) &&
        Objects.equals(this.completionDate, userTaskItem.completionDate) &&
        Objects.equals(this.followUpDate, userTaskItem.followUpDate) &&
        Objects.equals(this.dueDate, userTaskItem.dueDate) &&
        Objects.equals(this.tenantIds, userTaskItem.tenantIds) &&
        Objects.equals(this.externalFormReference, userTaskItem.externalFormReference) &&
        Objects.equals(this.processDefinitionVersion, userTaskItem.processDefinitionVersion) &&
        Objects.equals(this.customHeaders, userTaskItem.customHeaders) &&
        Objects.equals(this.priority, userTaskItem.priority);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, state, assignee, elementId, elementInstanceKey, candidateGroup, candidateUser, processDefinitionId, processDefinitionKey, processInstanceKey, formKey, creationDate, completionDate, followUpDate, dueDate, tenantIds, externalFormReference, processDefinitionVersion, customHeaders, priority);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserTaskItem {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    elementInstanceKey: ").append(toIndentedString(elementInstanceKey)).append("\n");
    sb.append("    candidateGroup: ").append(toIndentedString(candidateGroup)).append("\n");
    sb.append("    candidateUser: ").append(toIndentedString(candidateUser)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    formKey: ").append(toIndentedString(formKey)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    completionDate: ").append(toIndentedString(completionDate)).append("\n");
    sb.append("    followUpDate: ").append(toIndentedString(followUpDate)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    tenantIds: ").append(toIndentedString(tenantIds)).append("\n");
    sb.append("    externalFormReference: ").append(toIndentedString(externalFormReference)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    customHeaders: ").append(toIndentedString(customHeaders)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

