package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskVariableFilterRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * User task filter request.
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "UserTaskFilterRequest", description = "User task filter request.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class UserTaskFilterRequest {

  private Long key;

  private String state;

  private String assignee;

  private String elementId;

  private String candidateGroup;

  private String candidateUser;

  private Long processDefinitionKey;

  private Long processInstanceKey;

  private String tenantIds;

  private String processDefinitionId;

  @Valid
  private List<@Valid UserTaskVariableFilterRequest> variables = new ArrayList<>();

  public UserTaskFilterRequest key(Long key) {
    this.key = key;
    return this;
  }

  /**
   * Get key
   * @return key
   */
  
  @Schema(name = "key", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("key")
  public Long getKey() {
    return key;
  }

  public void setKey(Long key) {
    this.key = key;
  }

  public UserTaskFilterRequest state(String state) {
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
   */
  
  @Schema(name = "state", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("state")
  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public UserTaskFilterRequest assignee(String assignee) {
    this.assignee = assignee;
    return this;
  }

  /**
   * Get assignee
   * @return assignee
   */
  
  @Schema(name = "assignee", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("assignee")
  public String getAssignee() {
    return assignee;
  }

  public void setAssignee(String assignee) {
    this.assignee = assignee;
  }

  public UserTaskFilterRequest elementId(String elementId) {
    this.elementId = elementId;
    return this;
  }

  /**
   * Get elementId
   * @return elementId
   */
  
  @Schema(name = "elementId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("elementId")
  public String getElementId() {
    return elementId;
  }

  public void setElementId(String elementId) {
    this.elementId = elementId;
  }

  public UserTaskFilterRequest candidateGroup(String candidateGroup) {
    this.candidateGroup = candidateGroup;
    return this;
  }

  /**
   * Get candidateGroup
   * @return candidateGroup
   */
  
  @Schema(name = "candidateGroup", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("candidateGroup")
  public String getCandidateGroup() {
    return candidateGroup;
  }

  public void setCandidateGroup(String candidateGroup) {
    this.candidateGroup = candidateGroup;
  }

  public UserTaskFilterRequest candidateUser(String candidateUser) {
    this.candidateUser = candidateUser;
    return this;
  }

  /**
   * Get candidateUser
   * @return candidateUser
   */
  
  @Schema(name = "candidateUser", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("candidateUser")
  public String getCandidateUser() {
    return candidateUser;
  }

  public void setCandidateUser(String candidateUser) {
    this.candidateUser = candidateUser;
  }

  public UserTaskFilterRequest processDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * Get processDefinitionKey
   * @return processDefinitionKey
   */
  
  @Schema(name = "processDefinitionKey", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionKey")
  public Long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  public void setProcessDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public UserTaskFilterRequest processInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * Get processInstanceKey
   * @return processInstanceKey
   */
  
  @Schema(name = "processInstanceKey", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processInstanceKey")
  public Long getProcessInstanceKey() {
    return processInstanceKey;
  }

  public void setProcessInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public UserTaskFilterRequest tenantIds(String tenantIds) {
    this.tenantIds = tenantIds;
    return this;
  }

  /**
   * Get tenantIds
   * @return tenantIds
   */
  
  @Schema(name = "tenantIds", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantIds")
  public String getTenantIds() {
    return tenantIds;
  }

  public void setTenantIds(String tenantIds) {
    this.tenantIds = tenantIds;
  }

  public UserTaskFilterRequest processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * Get processDefinitionId
   * @return processDefinitionId
   */
  
  @Schema(name = "processDefinitionId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionId")
  public String getProcessDefinitionId() {
    return processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public UserTaskFilterRequest variables(List<@Valid UserTaskVariableFilterRequest> variables) {
    this.variables = variables;
    return this;
  }

  public UserTaskFilterRequest addVariablesItem(UserTaskVariableFilterRequest variablesItem) {
    if (this.variables == null) {
      this.variables = new ArrayList<>();
    }
    this.variables.add(variablesItem);
    return this;
  }

  /**
   * Get variables
   * @return variables
   */
  @Valid 
  @Schema(name = "variables", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("variables")
  public List<@Valid UserTaskVariableFilterRequest> getVariables() {
    return variables;
  }

  public void setVariables(List<@Valid UserTaskVariableFilterRequest> variables) {
    this.variables = variables;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserTaskFilterRequest userTaskFilterRequest = (UserTaskFilterRequest) o;
    return Objects.equals(this.key, userTaskFilterRequest.key) &&
        Objects.equals(this.state, userTaskFilterRequest.state) &&
        Objects.equals(this.assignee, userTaskFilterRequest.assignee) &&
        Objects.equals(this.elementId, userTaskFilterRequest.elementId) &&
        Objects.equals(this.candidateGroup, userTaskFilterRequest.candidateGroup) &&
        Objects.equals(this.candidateUser, userTaskFilterRequest.candidateUser) &&
        Objects.equals(this.processDefinitionKey, userTaskFilterRequest.processDefinitionKey) &&
        Objects.equals(this.processInstanceKey, userTaskFilterRequest.processInstanceKey) &&
        Objects.equals(this.tenantIds, userTaskFilterRequest.tenantIds) &&
        Objects.equals(this.processDefinitionId, userTaskFilterRequest.processDefinitionId) &&
        Objects.equals(this.variables, userTaskFilterRequest.variables);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, state, assignee, elementId, candidateGroup, candidateUser, processDefinitionKey, processInstanceKey, tenantIds, processDefinitionId, variables);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserTaskFilterRequest {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    candidateGroup: ").append(toIndentedString(candidateGroup)).append("\n");
    sb.append("    candidateUser: ").append(toIndentedString(candidateUser)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    tenantIds: ").append(toIndentedString(tenantIds)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

