package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * UserTaskCompletionRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class UserTaskCompletionRequest {

  @Valid
  private Map<String, Object> variables;

  private String action = null;

  public UserTaskCompletionRequest variables(Map<String, Object> variables) {
    this.variables = variables;
    return this;
  }

  public UserTaskCompletionRequest putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * The variables to complete the user task with.
   * @return variables
   */
  
  @Schema(name = "variables", description = "The variables to complete the user task with.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("variables")
  public Map<String, Object> getVariables() {
    return variables;
  }

  public void setVariables(Map<String, Object> variables) {
    this.variables = variables;
  }

  public UserTaskCompletionRequest action(String action) {
    this.action = action;
    return this;
  }

  /**
   * A custom action value that will be accessible from user task events resulting from this endpoint invocation. If not provided, it will default to \"complete\". 
   * @return action
   */
  
  @Schema(name = "action", description = "A custom action value that will be accessible from user task events resulting from this endpoint invocation. If not provided, it will default to \"complete\". ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("action")
  public String getAction() {
    return action;
  }

  public void setAction(String action) {
    this.action = action;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserTaskCompletionRequest userTaskCompletionRequest = (UserTaskCompletionRequest) o;
    return Objects.equals(this.variables, userTaskCompletionRequest.variables) &&
        Objects.equals(this.action, userTaskCompletionRequest.action);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variables, action);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserTaskCompletionRequest {\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    action: ").append(toIndentedString(action)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

