package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * UserTaskAssignmentRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class UserTaskAssignmentRequest {

  private String assignee;

  private Boolean allowOverride = null;

  private String action = null;

  public UserTaskAssignmentRequest assignee(String assignee) {
    this.assignee = assignee;
    return this;
  }

  /**
   * The assignee for the user task. The assignee must not be empty or `null`.
   * @return assignee
   */
  
  @Schema(name = "assignee", description = "The assignee for the user task. The assignee must not be empty or `null`.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("assignee")
  public String getAssignee() {
    return assignee;
  }

  public void setAssignee(String assignee) {
    this.assignee = assignee;
  }

  public UserTaskAssignmentRequest allowOverride(Boolean allowOverride) {
    this.allowOverride = allowOverride;
    return this;
  }

  /**
   * By default, the task is reassigned if it was already assigned. Set this to `false` to return an error in such cases. The task must then first be unassigned to be assigned again. Use this when you have users picking from group task queues to prevent race conditions. 
   * @return allowOverride
   */
  
  @Schema(name = "allowOverride", description = "By default, the task is reassigned if it was already assigned. Set this to `false` to return an error in such cases. The task must then first be unassigned to be assigned again. Use this when you have users picking from group task queues to prevent race conditions. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("allowOverride")
  public Boolean getAllowOverride() {
    return allowOverride;
  }

  public void setAllowOverride(Boolean allowOverride) {
    this.allowOverride = allowOverride;
  }

  public UserTaskAssignmentRequest action(String action) {
    this.action = action;
    return this;
  }

  /**
   * A custom action value that will be accessible from user task events resulting from this endpoint invocation. If not provided, it will default to \"assign\". 
   * @return action
   */
  
  @Schema(name = "action", description = "A custom action value that will be accessible from user task events resulting from this endpoint invocation. If not provided, it will default to \"assign\". ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("action")
  public String getAction() {
    return action;
  }

  public void setAction(String action) {
    this.action = action;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserTaskAssignmentRequest userTaskAssignmentRequest = (UserTaskAssignmentRequest) o;
    return Objects.equals(this.assignee, userTaskAssignmentRequest.assignee) &&
        Objects.equals(this.allowOverride, userTaskAssignmentRequest.allowOverride) &&
        Objects.equals(this.action, userTaskAssignmentRequest.action);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assignee, allowOverride, action);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserTaskAssignmentRequest {\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    allowOverride: ").append(toIndentedString(allowOverride)).append("\n");
    sb.append("    action: ").append(toIndentedString(action)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

