package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.gateway.protocol.rest.BrokerInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * The response of a topology request.
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "TopologyResponse", description = "The response of a topology request.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class TopologyResponse {

  @Valid
  private List<@Valid BrokerInfo> brokers;

  private Integer clusterSize = null;

  private Integer partitionsCount = null;

  private Integer replicationFactor = null;

  private String gatewayVersion = null;

  public TopologyResponse brokers(List<@Valid BrokerInfo> brokers) {
    this.brokers = brokers;
    return this;
  }

  public TopologyResponse addBrokersItem(BrokerInfo brokersItem) {
    if (this.brokers == null) {
      this.brokers = new ArrayList<>();
    }
    this.brokers.add(brokersItem);
    return this;
  }

  /**
   * A list of brokers that are part of this cluster.
   * @return brokers
   */
  @Valid 
  @Schema(name = "brokers", description = "A list of brokers that are part of this cluster.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("brokers")
  public List<@Valid BrokerInfo> getBrokers() {
    return brokers;
  }

  public void setBrokers(List<@Valid BrokerInfo> brokers) {
    this.brokers = brokers;
  }

  public TopologyResponse clusterSize(Integer clusterSize) {
    this.clusterSize = clusterSize;
    return this;
  }

  /**
   * The number of brokers in the cluster.
   * @return clusterSize
   */
  
  @Schema(name = "clusterSize", description = "The number of brokers in the cluster.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("clusterSize")
  public Integer getClusterSize() {
    return clusterSize;
  }

  public void setClusterSize(Integer clusterSize) {
    this.clusterSize = clusterSize;
  }

  public TopologyResponse partitionsCount(Integer partitionsCount) {
    this.partitionsCount = partitionsCount;
    return this;
  }

  /**
   * The number of partitions are spread across the cluster.
   * @return partitionsCount
   */
  
  @Schema(name = "partitionsCount", description = "The number of partitions are spread across the cluster.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("partitionsCount")
  public Integer getPartitionsCount() {
    return partitionsCount;
  }

  public void setPartitionsCount(Integer partitionsCount) {
    this.partitionsCount = partitionsCount;
  }

  public TopologyResponse replicationFactor(Integer replicationFactor) {
    this.replicationFactor = replicationFactor;
    return this;
  }

  /**
   * The configured replication factor for this cluster.
   * @return replicationFactor
   */
  
  @Schema(name = "replicationFactor", description = "The configured replication factor for this cluster.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("replicationFactor")
  public Integer getReplicationFactor() {
    return replicationFactor;
  }

  public void setReplicationFactor(Integer replicationFactor) {
    this.replicationFactor = replicationFactor;
  }

  public TopologyResponse gatewayVersion(String gatewayVersion) {
    this.gatewayVersion = gatewayVersion;
    return this;
  }

  /**
   * The version of the Zeebe Gateway.
   * @return gatewayVersion
   */
  
  @Schema(name = "gatewayVersion", description = "The version of the Zeebe Gateway.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("gatewayVersion")
  public String getGatewayVersion() {
    return gatewayVersion;
  }

  public void setGatewayVersion(String gatewayVersion) {
    this.gatewayVersion = gatewayVersion;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TopologyResponse topologyResponse = (TopologyResponse) o;
    return Objects.equals(this.brokers, topologyResponse.brokers) &&
        Objects.equals(this.clusterSize, topologyResponse.clusterSize) &&
        Objects.equals(this.partitionsCount, topologyResponse.partitionsCount) &&
        Objects.equals(this.replicationFactor, topologyResponse.replicationFactor) &&
        Objects.equals(this.gatewayVersion, topologyResponse.gatewayVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(brokers, clusterSize, partitionsCount, replicationFactor, gatewayVersion);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TopologyResponse {\n");
    sb.append("    brokers: ").append(toIndentedString(brokers)).append("\n");
    sb.append("    clusterSize: ").append(toIndentedString(clusterSize)).append("\n");
    sb.append("    partitionsCount: ").append(toIndentedString(partitionsCount)).append("\n");
    sb.append("    replicationFactor: ").append(toIndentedString(replicationFactor)).append("\n");
    sb.append("    gatewayVersion: ").append(toIndentedString(gatewayVersion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

