package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * SignalBroadcastResponse
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class SignalBroadcastResponse {

  private Long signalKey;

  private String tenantId;

  public SignalBroadcastResponse signalKey(Long signalKey) {
    this.signalKey = signalKey;
    return this;
  }

  /**
   * The unique ID of the signal that was broadcast.
   * @return signalKey
   */
  
  @Schema(name = "signalKey", description = "The unique ID of the signal that was broadcast.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("signalKey")
  public Long getSignalKey() {
    return signalKey;
  }

  public void setSignalKey(Long signalKey) {
    this.signalKey = signalKey;
  }

  public SignalBroadcastResponse tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the signal that was broadcast.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant ID of the signal that was broadcast.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SignalBroadcastResponse signalBroadcastResponse = (SignalBroadcastResponse) o;
    return Objects.equals(this.signalKey, signalBroadcastResponse.signalKey) &&
        Objects.equals(this.tenantId, signalBroadcastResponse.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(signalKey, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SignalBroadcastResponse {\n");
    sb.append("    signalKey: ").append(toIndentedString(signalKey)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

