package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * SignalBroadcastRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class SignalBroadcastRequest {

  private String signalName;

  @Valid
  private Map<String, Object> variables = new HashMap<>();

  private String tenantId;

  public SignalBroadcastRequest() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public SignalBroadcastRequest(String signalName) {
    this.signalName = signalName;
  }

  public SignalBroadcastRequest signalName(String signalName) {
    this.signalName = signalName;
    return this;
  }

  /**
   * The name of the signal to broadcast.
   * @return signalName
   */
  @NotNull 
  @Schema(name = "signalName", description = "The name of the signal to broadcast.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("signalName")
  public String getSignalName() {
    return signalName;
  }

  public void setSignalName(String signalName) {
    this.signalName = signalName;
  }

  public SignalBroadcastRequest variables(Map<String, Object> variables) {
    this.variables = variables;
    return this;
  }

  public SignalBroadcastRequest putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * The signal variables as a JSON object.
   * @return variables
   */
  
  @Schema(name = "variables", description = "The signal variables as a JSON object.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("variables")
  public Map<String, Object> getVariables() {
    return variables;
  }

  public void setVariables(Map<String, Object> variables) {
    this.variables = variables;
  }

  public SignalBroadcastRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The ID of the tenant that owns the signal.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The ID of the tenant that owns the signal.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SignalBroadcastRequest signalBroadcastRequest = (SignalBroadcastRequest) o;
    return Objects.equals(this.signalName, signalBroadcastRequest.signalName) &&
        Objects.equals(this.variables, signalBroadcastRequest.variables) &&
        Objects.equals(this.tenantId, signalBroadcastRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(signalName, variables, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SignalBroadcastRequest {\n");
    sb.append("    signalName: ").append(toIndentedString(signalName)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

