package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * SetVariableRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class SetVariableRequest {

  @Valid
  private Map<String, Object> variables = new HashMap<>();

  private Boolean local = false;

  private Long operationReference;

  public SetVariableRequest() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public SetVariableRequest(Map<String, Object> variables) {
    this.variables = variables;
  }

  public SetVariableRequest variables(Map<String, Object> variables) {
    this.variables = variables;
    return this;
  }

  public SetVariableRequest putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * JSON object representing the variables to set in the element’s scope.
   * @return variables
   */
  @NotNull 
  @Schema(name = "variables", description = "JSON object representing the variables to set in the element’s scope.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("variables")
  public Map<String, Object> getVariables() {
    return variables;
  }

  public void setVariables(Map<String, Object> variables) {
    this.variables = variables;
  }

  public SetVariableRequest local(Boolean local) {
    this.local = local;
    return this;
  }

  /**
   * If set to true, the variables are merged strictly into the local scope (as specified by the `elementInstanceKey`). Otherwise, the variables are propagated to upper scopes and set at the outermost one.  Let’s consider the following example:  There are two scopes '1' and '2'. Scope '1' is the parent scope of '2'. The effective variables of the scopes are: 1 => { \"foo\" : 2 } 2 => { \"bar\" : 1 }  An update request with elementInstanceKey as '2', variables { \"foo\" : 5 }, and local set to true leaves scope '1' unchanged and adjusts scope '2' to { \"bar\" : 1, \"foo\" 5 }.  By default, with local set to false, scope '1' will be { \"foo\": 5 } and scope '2' will be { \"bar\" : 1 }. 
   * @return local
   */
  
  @Schema(name = "local", description = "If set to true, the variables are merged strictly into the local scope (as specified by the `elementInstanceKey`). Otherwise, the variables are propagated to upper scopes and set at the outermost one.  Let’s consider the following example:  There are two scopes '1' and '2'. Scope '1' is the parent scope of '2'. The effective variables of the scopes are: 1 => { \"foo\" : 2 } 2 => { \"bar\" : 1 }  An update request with elementInstanceKey as '2', variables { \"foo\" : 5 }, and local set to true leaves scope '1' unchanged and adjusts scope '2' to { \"bar\" : 1, \"foo\" 5 }.  By default, with local set to false, scope '1' will be { \"foo\": 5 } and scope '2' will be { \"bar\" : 1 }. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("local")
  public Boolean getLocal() {
    return local;
  }

  public void setLocal(Boolean local) {
    this.local = local;
  }

  public SetVariableRequest operationReference(Long operationReference) {
    this.operationReference = operationReference;
    return this;
  }

  /**
   * A reference key chosen by the user that will be part of all records resulting from this operation. Must be > 0 if provided. 
   * minimum: 1
   * @return operationReference
   */
  @Min(1L) 
  @Schema(name = "operationReference", description = "A reference key chosen by the user that will be part of all records resulting from this operation. Must be > 0 if provided. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("operationReference")
  public Long getOperationReference() {
    return operationReference;
  }

  public void setOperationReference(Long operationReference) {
    this.operationReference = operationReference;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SetVariableRequest setVariableRequest = (SetVariableRequest) o;
    return Objects.equals(this.variables, setVariableRequest.variables) &&
        Objects.equals(this.local, setVariableRequest.local) &&
        Objects.equals(this.operationReference, setVariableRequest.operationReference);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variables, local, operationReference);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SetVariableRequest {\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    local: ").append(toIndentedString(local)).append("\n");
    sb.append("    operationReference: ").append(toIndentedString(operationReference)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

