package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * SearchQueryPageRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class SearchQueryPageRequest {

  private Integer from;

  private Integer limit;

  @Valid
  private List<Object> searchAfter = new ArrayList<>();

  @Valid
  private List<Object> searchBefore = new ArrayList<>();

  public SearchQueryPageRequest from(Integer from) {
    this.from = from;
    return this;
  }

  /**
   * Get from
   * @return from
   */
  
  @Schema(name = "from", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("from")
  public Integer getFrom() {
    return from;
  }

  public void setFrom(Integer from) {
    this.from = from;
  }

  public SearchQueryPageRequest limit(Integer limit) {
    this.limit = limit;
    return this;
  }

  /**
   * Get limit
   * @return limit
   */
  
  @Schema(name = "limit", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("limit")
  public Integer getLimit() {
    return limit;
  }

  public void setLimit(Integer limit) {
    this.limit = limit;
  }

  public SearchQueryPageRequest searchAfter(List<Object> searchAfter) {
    this.searchAfter = searchAfter;
    return this;
  }

  public SearchQueryPageRequest addSearchAfterItem(Object searchAfterItem) {
    if (this.searchAfter == null) {
      this.searchAfter = new ArrayList<>();
    }
    this.searchAfter.add(searchAfterItem);
    return this;
  }

  /**
   * Get searchAfter
   * @return searchAfter
   */
  
  @Schema(name = "searchAfter", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("searchAfter")
  public List<Object> getSearchAfter() {
    return searchAfter;
  }

  public void setSearchAfter(List<Object> searchAfter) {
    this.searchAfter = searchAfter;
  }

  public SearchQueryPageRequest searchBefore(List<Object> searchBefore) {
    this.searchBefore = searchBefore;
    return this;
  }

  public SearchQueryPageRequest addSearchBeforeItem(Object searchBeforeItem) {
    if (this.searchBefore == null) {
      this.searchBefore = new ArrayList<>();
    }
    this.searchBefore.add(searchBeforeItem);
    return this;
  }

  /**
   * Get searchBefore
   * @return searchBefore
   */
  
  @Schema(name = "searchBefore", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("searchBefore")
  public List<Object> getSearchBefore() {
    return searchBefore;
  }

  public void setSearchBefore(List<Object> searchBefore) {
    this.searchBefore = searchBefore;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchQueryPageRequest searchQueryPageRequest = (SearchQueryPageRequest) o;
    return Objects.equals(this.from, searchQueryPageRequest.from) &&
        Objects.equals(this.limit, searchQueryPageRequest.limit) &&
        Objects.equals(this.searchAfter, searchQueryPageRequest.searchAfter) &&
        Objects.equals(this.searchBefore, searchQueryPageRequest.searchBefore);
  }

  @Override
  public int hashCode() {
    return Objects.hash(from, limit, searchAfter, searchBefore);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchQueryPageRequest {\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    searchAfter: ").append(toIndentedString(searchAfter)).append("\n");
    sb.append("    searchBefore: ").append(toIndentedString(searchBefore)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

