package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.gateway.protocol.rest.ProcessInstanceFilterRequest;
import io.camunda.zeebe.gateway.protocol.rest.SearchQueryPageRequest;
import io.camunda.zeebe.gateway.protocol.rest.SearchQuerySortRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * ProcessInstanceSearchQueryRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class ProcessInstanceSearchQueryRequest {

  private ProcessInstanceFilterRequest filter;

  @Valid
  private List<SearchQuerySortRequest> sort = new ArrayList<>();

  private SearchQueryPageRequest page;

  public ProcessInstanceSearchQueryRequest filter(ProcessInstanceFilterRequest filter) {
    this.filter = filter;
    return this;
  }

  /**
   * Get filter
   * @return filter
   */
  @Valid 
  @Schema(name = "filter", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("filter")
  public ProcessInstanceFilterRequest getFilter() {
    return filter;
  }

  public void setFilter(ProcessInstanceFilterRequest filter) {
    this.filter = filter;
  }

  public ProcessInstanceSearchQueryRequest sort(List<SearchQuerySortRequest> sort) {
    this.sort = sort;
    return this;
  }

  public ProcessInstanceSearchQueryRequest addSortItem(SearchQuerySortRequest sortItem) {
    if (this.sort == null) {
      this.sort = new ArrayList<>();
    }
    this.sort.add(sortItem);
    return this;
  }

  /**
   * Get sort
   * @return sort
   */
  @Valid 
  @Schema(name = "sort", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("sort")
  public List<SearchQuerySortRequest> getSort() {
    return sort;
  }

  public void setSort(List<SearchQuerySortRequest> sort) {
    this.sort = sort;
  }

  public ProcessInstanceSearchQueryRequest page(SearchQueryPageRequest page) {
    this.page = page;
    return this;
  }

  /**
   * Get page
   * @return page
   */
  @Valid 
  @Schema(name = "page", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("page")
  public SearchQueryPageRequest getPage() {
    return page;
  }

  public void setPage(SearchQueryPageRequest page) {
    this.page = page;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceSearchQueryRequest processInstanceSearchQueryRequest = (ProcessInstanceSearchQueryRequest) o;
    return Objects.equals(this.filter, processInstanceSearchQueryRequest.filter) &&
        Objects.equals(this.sort, processInstanceSearchQueryRequest.sort) &&
        Objects.equals(this.page, processInstanceSearchQueryRequest.page);
  }

  @Override
  public int hashCode() {
    return Objects.hash(filter, sort, page);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceSearchQueryRequest {\n");
    sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

