package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.gateway.protocol.rest.OperationItem;
import io.camunda.zeebe.gateway.protocol.rest.ProcessInstanceReferenceItem;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * ProcessInstanceItem
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class ProcessInstanceItem {

  private Long key;

  private String processDefinitionName;

  private Integer processDefinitionVersion;

  private String bpmnProcessId;

  private Long parentKey;

  private Long parentFlowNodeInstanceKey;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private String startDate;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private String endDate;

  /**
   * Gets or Sets state
   */
  public enum StateEnum {
    ACTIVE("ACTIVE"),
    
    INCIDENT("INCIDENT"),
    
    COMPLETED("COMPLETED"),
    
    CANCELED("CANCELED"),
    
    UNKNOWN("UNKNOWN"),
    
    UNSPECIFIED("UNSPECIFIED");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private StateEnum state;

  private Boolean incident;

  private Boolean hasActiveOperation;

  private Long processDefinitionKey;

  private String tenantId;

  private String rootInstanceId;

  @Valid
  private List<@Valid OperationItem> operations = new ArrayList<>();

  @Valid
  private List<@Valid ProcessInstanceReferenceItem> callHierarchy = new ArrayList<>();

  public ProcessInstanceItem key(Long key) {
    this.key = key;
    return this;
  }

  /**
   * Get key
   * @return key
   */
  
  @Schema(name = "key", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("key")
  public Long getKey() {
    return key;
  }

  public void setKey(Long key) {
    this.key = key;
  }

  public ProcessInstanceItem processDefinitionName(String processDefinitionName) {
    this.processDefinitionName = processDefinitionName;
    return this;
  }

  /**
   * The process name.
   * @return processDefinitionName
   */
  
  @Schema(name = "processDefinitionName", description = "The process name.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionName")
  public String getProcessDefinitionName() {
    return processDefinitionName;
  }

  public void setProcessDefinitionName(String processDefinitionName) {
    this.processDefinitionName = processDefinitionName;
  }

  public ProcessInstanceItem processDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * Get processDefinitionVersion
   * @return processDefinitionVersion
   */
  
  @Schema(name = "processDefinitionVersion", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionVersion")
  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }

  public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public ProcessInstanceItem bpmnProcessId(String bpmnProcessId) {
    this.bpmnProcessId = bpmnProcessId;
    return this;
  }

  /**
   * Get bpmnProcessId
   * @return bpmnProcessId
   */
  
  @Schema(name = "bpmnProcessId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("bpmnProcessId")
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  public void setBpmnProcessId(String bpmnProcessId) {
    this.bpmnProcessId = bpmnProcessId;
  }

  public ProcessInstanceItem parentKey(Long parentKey) {
    this.parentKey = parentKey;
    return this;
  }

  /**
   * Get parentKey
   * @return parentKey
   */
  
  @Schema(name = "parentKey", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("parentKey")
  public Long getParentKey() {
    return parentKey;
  }

  public void setParentKey(Long parentKey) {
    this.parentKey = parentKey;
  }

  public ProcessInstanceItem parentFlowNodeInstanceKey(Long parentFlowNodeInstanceKey) {
    this.parentFlowNodeInstanceKey = parentFlowNodeInstanceKey;
    return this;
  }

  /**
   * Get parentFlowNodeInstanceKey
   * @return parentFlowNodeInstanceKey
   */
  
  @Schema(name = "parentFlowNodeInstanceKey", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("parentFlowNodeInstanceKey")
  public Long getParentFlowNodeInstanceKey() {
    return parentFlowNodeInstanceKey;
  }

  public void setParentFlowNodeInstanceKey(Long parentFlowNodeInstanceKey) {
    this.parentFlowNodeInstanceKey = parentFlowNodeInstanceKey;
  }

  public ProcessInstanceItem startDate(String startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * Get startDate
   * @return startDate
   */
  @Valid 
  @Schema(name = "startDate", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("startDate")
  public String getStartDate() {
    return startDate;
  }

  public void setStartDate(String startDate) {
    this.startDate = startDate;
  }

  public ProcessInstanceItem endDate(String endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * Get endDate
   * @return endDate
   */
  @Valid 
  @Schema(name = "endDate", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("endDate")
  public String getEndDate() {
    return endDate;
  }

  public void setEndDate(String endDate) {
    this.endDate = endDate;
  }

  public ProcessInstanceItem state(StateEnum state) {
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
   */
  
  @Schema(name = "state", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("state")
  public StateEnum getState() {
    return state;
  }

  public void setState(StateEnum state) {
    this.state = state;
  }

  public ProcessInstanceItem incident(Boolean incident) {
    this.incident = incident;
    return this;
  }

  /**
   * Get incident
   * @return incident
   */
  
  @Schema(name = "incident", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("incident")
  public Boolean getIncident() {
    return incident;
  }

  public void setIncident(Boolean incident) {
    this.incident = incident;
  }

  public ProcessInstanceItem hasActiveOperation(Boolean hasActiveOperation) {
    this.hasActiveOperation = hasActiveOperation;
    return this;
  }

  /**
   * Get hasActiveOperation
   * @return hasActiveOperation
   */
  
  @Schema(name = "hasActiveOperation", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hasActiveOperation")
  public Boolean getHasActiveOperation() {
    return hasActiveOperation;
  }

  public void setHasActiveOperation(Boolean hasActiveOperation) {
    this.hasActiveOperation = hasActiveOperation;
  }

  public ProcessInstanceItem processDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * Get processDefinitionKey
   * @return processDefinitionKey
   */
  
  @Schema(name = "processDefinitionKey", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionKey")
  public Long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  public void setProcessDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public ProcessInstanceItem tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * Get tenantId
   * @return tenantId
   */
  
  @Schema(name = "tenantId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public ProcessInstanceItem rootInstanceId(String rootInstanceId) {
    this.rootInstanceId = rootInstanceId;
    return this;
  }

  /**
   * Get rootInstanceId
   * @return rootInstanceId
   */
  
  @Schema(name = "rootInstanceId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("rootInstanceId")
  public String getRootInstanceId() {
    return rootInstanceId;
  }

  public void setRootInstanceId(String rootInstanceId) {
    this.rootInstanceId = rootInstanceId;
  }

  public ProcessInstanceItem operations(List<@Valid OperationItem> operations) {
    this.operations = operations;
    return this;
  }

  public ProcessInstanceItem addOperationsItem(OperationItem operationsItem) {
    if (this.operations == null) {
      this.operations = new ArrayList<>();
    }
    this.operations.add(operationsItem);
    return this;
  }

  /**
   * Get operations
   * @return operations
   */
  @Valid 
  @Schema(name = "operations", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("operations")
  public List<@Valid OperationItem> getOperations() {
    return operations;
  }

  public void setOperations(List<@Valid OperationItem> operations) {
    this.operations = operations;
  }

  public ProcessInstanceItem callHierarchy(List<@Valid ProcessInstanceReferenceItem> callHierarchy) {
    this.callHierarchy = callHierarchy;
    return this;
  }

  public ProcessInstanceItem addCallHierarchyItem(ProcessInstanceReferenceItem callHierarchyItem) {
    if (this.callHierarchy == null) {
      this.callHierarchy = new ArrayList<>();
    }
    this.callHierarchy.add(callHierarchyItem);
    return this;
  }

  /**
   * Get callHierarchy
   * @return callHierarchy
   */
  @Valid 
  @Schema(name = "callHierarchy", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("callHierarchy")
  public List<@Valid ProcessInstanceReferenceItem> getCallHierarchy() {
    return callHierarchy;
  }

  public void setCallHierarchy(List<@Valid ProcessInstanceReferenceItem> callHierarchy) {
    this.callHierarchy = callHierarchy;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceItem processInstanceItem = (ProcessInstanceItem) o;
    return Objects.equals(this.key, processInstanceItem.key) &&
        Objects.equals(this.processDefinitionName, processInstanceItem.processDefinitionName) &&
        Objects.equals(this.processDefinitionVersion, processInstanceItem.processDefinitionVersion) &&
        Objects.equals(this.bpmnProcessId, processInstanceItem.bpmnProcessId) &&
        Objects.equals(this.parentKey, processInstanceItem.parentKey) &&
        Objects.equals(this.parentFlowNodeInstanceKey, processInstanceItem.parentFlowNodeInstanceKey) &&
        Objects.equals(this.startDate, processInstanceItem.startDate) &&
        Objects.equals(this.endDate, processInstanceItem.endDate) &&
        Objects.equals(this.state, processInstanceItem.state) &&
        Objects.equals(this.incident, processInstanceItem.incident) &&
        Objects.equals(this.hasActiveOperation, processInstanceItem.hasActiveOperation) &&
        Objects.equals(this.processDefinitionKey, processInstanceItem.processDefinitionKey) &&
        Objects.equals(this.tenantId, processInstanceItem.tenantId) &&
        Objects.equals(this.rootInstanceId, processInstanceItem.rootInstanceId) &&
        Objects.equals(this.operations, processInstanceItem.operations) &&
        Objects.equals(this.callHierarchy, processInstanceItem.callHierarchy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, processDefinitionName, processDefinitionVersion, bpmnProcessId, parentKey, parentFlowNodeInstanceKey, startDate, endDate, state, incident, hasActiveOperation, processDefinitionKey, tenantId, rootInstanceId, operations, callHierarchy);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceItem {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    processDefinitionName: ").append(toIndentedString(processDefinitionName)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    bpmnProcessId: ").append(toIndentedString(bpmnProcessId)).append("\n");
    sb.append("    parentKey: ").append(toIndentedString(parentKey)).append("\n");
    sb.append("    parentFlowNodeInstanceKey: ").append(toIndentedString(parentFlowNodeInstanceKey)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    incident: ").append(toIndentedString(incident)).append("\n");
    sb.append("    hasActiveOperation: ").append(toIndentedString(hasActiveOperation)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    rootInstanceId: ").append(toIndentedString(rootInstanceId)).append("\n");
    sb.append("    operations: ").append(toIndentedString(operations)).append("\n");
    sb.append("    callHierarchy: ").append(toIndentedString(callHierarchy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

