package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.gateway.protocol.rest.ProcessInstanceVariableFilterRequest;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * ProcessInstanceFilterRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class ProcessInstanceFilterRequest {

  private Boolean running;

  private Boolean active;

  private Boolean incidents;

  private Boolean finished;

  private Boolean completed;

  private Boolean canceled;

  private Boolean retriesLeft;

  private String errorMessage;

  private String activityId;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private String startDate;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private String endDate;

  private String bpmnProcessId;

  private Integer processDefinitionVersion;

  private ProcessInstanceVariableFilterRequest variable;

  private String batchOperationId;

  private Long parentProcessInstanceKey;

  private String tenantId;

  public ProcessInstanceFilterRequest running(Boolean running) {
    this.running = running;
    return this;
  }

  /**
   * Get running
   * @return running
   */
  
  @Schema(name = "running", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("running")
  public Boolean getRunning() {
    return running;
  }

  public void setRunning(Boolean running) {
    this.running = running;
  }

  public ProcessInstanceFilterRequest active(Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Get active
   * @return active
   */
  
  @Schema(name = "active", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("active")
  public Boolean getActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  public ProcessInstanceFilterRequest incidents(Boolean incidents) {
    this.incidents = incidents;
    return this;
  }

  /**
   * Get incidents
   * @return incidents
   */
  
  @Schema(name = "incidents", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("incidents")
  public Boolean getIncidents() {
    return incidents;
  }

  public void setIncidents(Boolean incidents) {
    this.incidents = incidents;
  }

  public ProcessInstanceFilterRequest finished(Boolean finished) {
    this.finished = finished;
    return this;
  }

  /**
   * Get finished
   * @return finished
   */
  
  @Schema(name = "finished", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("finished")
  public Boolean getFinished() {
    return finished;
  }

  public void setFinished(Boolean finished) {
    this.finished = finished;
  }

  public ProcessInstanceFilterRequest completed(Boolean completed) {
    this.completed = completed;
    return this;
  }

  /**
   * Get completed
   * @return completed
   */
  
  @Schema(name = "completed", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("completed")
  public Boolean getCompleted() {
    return completed;
  }

  public void setCompleted(Boolean completed) {
    this.completed = completed;
  }

  public ProcessInstanceFilterRequest canceled(Boolean canceled) {
    this.canceled = canceled;
    return this;
  }

  /**
   * Get canceled
   * @return canceled
   */
  
  @Schema(name = "canceled", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("canceled")
  public Boolean getCanceled() {
    return canceled;
  }

  public void setCanceled(Boolean canceled) {
    this.canceled = canceled;
  }

  public ProcessInstanceFilterRequest retriesLeft(Boolean retriesLeft) {
    this.retriesLeft = retriesLeft;
    return this;
  }

  /**
   * Get retriesLeft
   * @return retriesLeft
   */
  
  @Schema(name = "retriesLeft", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("retriesLeft")
  public Boolean getRetriesLeft() {
    return retriesLeft;
  }

  public void setRetriesLeft(Boolean retriesLeft) {
    this.retriesLeft = retriesLeft;
  }

  public ProcessInstanceFilterRequest errorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * Get errorMessage
   * @return errorMessage
   */
  
  @Schema(name = "errorMessage", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("errorMessage")
  public String getErrorMessage() {
    return errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public ProcessInstanceFilterRequest activityId(String activityId) {
    this.activityId = activityId;
    return this;
  }

  /**
   * Get activityId
   * @return activityId
   */
  
  @Schema(name = "activityId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("activityId")
  public String getActivityId() {
    return activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = activityId;
  }

  public ProcessInstanceFilterRequest startDate(String startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * Get startDate
   * @return startDate
   */
  @Valid 
  @Schema(name = "startDate", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("startDate")
  public String getStartDate() {
    return startDate;
  }

  public void setStartDate(String startDate) {
    this.startDate = startDate;
  }

  public ProcessInstanceFilterRequest endDate(String endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * Get endDate
   * @return endDate
   */
  @Valid 
  @Schema(name = "endDate", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("endDate")
  public String getEndDate() {
    return endDate;
  }

  public void setEndDate(String endDate) {
    this.endDate = endDate;
  }

  public ProcessInstanceFilterRequest bpmnProcessId(String bpmnProcessId) {
    this.bpmnProcessId = bpmnProcessId;
    return this;
  }

  /**
   * The bpmn process ID.
   * @return bpmnProcessId
   */
  
  @Schema(name = "bpmnProcessId", description = "The bpmn process ID.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("bpmnProcessId")
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  public void setBpmnProcessId(String bpmnProcessId) {
    this.bpmnProcessId = bpmnProcessId;
  }

  public ProcessInstanceFilterRequest processDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * Get processDefinitionVersion
   * @return processDefinitionVersion
   */
  
  @Schema(name = "processDefinitionVersion", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionVersion")
  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }

  public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public ProcessInstanceFilterRequest variable(ProcessInstanceVariableFilterRequest variable) {
    this.variable = variable;
    return this;
  }

  /**
   * Get variable
   * @return variable
   */
  @Valid 
  @Schema(name = "variable", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("variable")
  public ProcessInstanceVariableFilterRequest getVariable() {
    return variable;
  }

  public void setVariable(ProcessInstanceVariableFilterRequest variable) {
    this.variable = variable;
  }

  public ProcessInstanceFilterRequest batchOperationId(String batchOperationId) {
    this.batchOperationId = batchOperationId;
    return this;
  }

  /**
   * Get batchOperationId
   * @return batchOperationId
   */
  
  @Schema(name = "batchOperationId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("batchOperationId")
  public String getBatchOperationId() {
    return batchOperationId;
  }

  public void setBatchOperationId(String batchOperationId) {
    this.batchOperationId = batchOperationId;
  }

  public ProcessInstanceFilterRequest parentProcessInstanceKey(Long parentProcessInstanceKey) {
    this.parentProcessInstanceKey = parentProcessInstanceKey;
    return this;
  }

  /**
   * Get parentProcessInstanceKey
   * @return parentProcessInstanceKey
   */
  
  @Schema(name = "parentProcessInstanceKey", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("parentProcessInstanceKey")
  public Long getParentProcessInstanceKey() {
    return parentProcessInstanceKey;
  }

  public void setParentProcessInstanceKey(Long parentProcessInstanceKey) {
    this.parentProcessInstanceKey = parentProcessInstanceKey;
  }

  public ProcessInstanceFilterRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * Get tenantId
   * @return tenantId
   */
  
  @Schema(name = "tenantId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceFilterRequest processInstanceFilterRequest = (ProcessInstanceFilterRequest) o;
    return Objects.equals(this.running, processInstanceFilterRequest.running) &&
        Objects.equals(this.active, processInstanceFilterRequest.active) &&
        Objects.equals(this.incidents, processInstanceFilterRequest.incidents) &&
        Objects.equals(this.finished, processInstanceFilterRequest.finished) &&
        Objects.equals(this.completed, processInstanceFilterRequest.completed) &&
        Objects.equals(this.canceled, processInstanceFilterRequest.canceled) &&
        Objects.equals(this.retriesLeft, processInstanceFilterRequest.retriesLeft) &&
        Objects.equals(this.errorMessage, processInstanceFilterRequest.errorMessage) &&
        Objects.equals(this.activityId, processInstanceFilterRequest.activityId) &&
        Objects.equals(this.startDate, processInstanceFilterRequest.startDate) &&
        Objects.equals(this.endDate, processInstanceFilterRequest.endDate) &&
        Objects.equals(this.bpmnProcessId, processInstanceFilterRequest.bpmnProcessId) &&
        Objects.equals(this.processDefinitionVersion, processInstanceFilterRequest.processDefinitionVersion) &&
        Objects.equals(this.variable, processInstanceFilterRequest.variable) &&
        Objects.equals(this.batchOperationId, processInstanceFilterRequest.batchOperationId) &&
        Objects.equals(this.parentProcessInstanceKey, processInstanceFilterRequest.parentProcessInstanceKey) &&
        Objects.equals(this.tenantId, processInstanceFilterRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(running, active, incidents, finished, completed, canceled, retriesLeft, errorMessage, activityId, startDate, endDate, bpmnProcessId, processDefinitionVersion, variable, batchOperationId, parentProcessInstanceKey, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceFilterRequest {\n");
    sb.append("    running: ").append(toIndentedString(running)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    incidents: ").append(toIndentedString(incidents)).append("\n");
    sb.append("    finished: ").append(toIndentedString(finished)).append("\n");
    sb.append("    completed: ").append(toIndentedString(completed)).append("\n");
    sb.append("    canceled: ").append(toIndentedString(canceled)).append("\n");
    sb.append("    retriesLeft: ").append(toIndentedString(retriesLeft)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    bpmnProcessId: ").append(toIndentedString(bpmnProcessId)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    variable: ").append(toIndentedString(variable)).append("\n");
    sb.append("    batchOperationId: ").append(toIndentedString(batchOperationId)).append("\n");
    sb.append("    parentProcessInstanceKey: ").append(toIndentedString(parentProcessInstanceKey)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

