package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Provides information on a partition within a broker node.
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "Partition", description = "Provides information on a partition within a broker node.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class Partition {

  private Integer partitionId;

  /**
   * Describes the Raft role of the broker for a given partition.
   */
  public enum RoleEnum {
    LEADER("leader"),
    
    FOLLOWER("follower"),
    
    INACTIVE("inactive");

    private String value;

    RoleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RoleEnum fromValue(String value) {
      for (RoleEnum b : RoleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private RoleEnum role;

  /**
   * Describes the current health of the partition.
   */
  public enum HealthEnum {
    HEALTHY("healthy"),
    
    UNHEALTHY("unhealthy"),
    
    DEAD("dead");

    private String value;

    HealthEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static HealthEnum fromValue(String value) {
      for (HealthEnum b : HealthEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private HealthEnum health;

  public Partition partitionId(Integer partitionId) {
    this.partitionId = partitionId;
    return this;
  }

  /**
   * The unique ID of this partition.
   * @return partitionId
   */
  
  @Schema(name = "partitionId", description = "The unique ID of this partition.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("partitionId")
  public Integer getPartitionId() {
    return partitionId;
  }

  public void setPartitionId(Integer partitionId) {
    this.partitionId = partitionId;
  }

  public Partition role(RoleEnum role) {
    this.role = role;
    return this;
  }

  /**
   * Describes the Raft role of the broker for a given partition.
   * @return role
   */
  
  @Schema(name = "role", description = "Describes the Raft role of the broker for a given partition.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("role")
  public RoleEnum getRole() {
    return role;
  }

  public void setRole(RoleEnum role) {
    this.role = role;
  }

  public Partition health(HealthEnum health) {
    this.health = health;
    return this;
  }

  /**
   * Describes the current health of the partition.
   * @return health
   */
  
  @Schema(name = "health", description = "Describes the current health of the partition.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("health")
  public HealthEnum getHealth() {
    return health;
  }

  public void setHealth(HealthEnum health) {
    this.health = health;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Partition partition = (Partition) o;
    return Objects.equals(this.partitionId, partition.partitionId) &&
        Objects.equals(this.role, partition.role) &&
        Objects.equals(this.health, partition.health);
  }

  @Override
  public int hashCode() {
    return Objects.hash(partitionId, role, health);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Partition {\n");
    sb.append("    partitionId: ").append(toIndentedString(partitionId)).append("\n");
    sb.append("    role: ").append(toIndentedString(role)).append("\n");
    sb.append("    health: ").append(toIndentedString(health)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

