package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 *  Operation
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "OperationItem", description = " Operation")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class OperationItem {

  private String id;

  private String batchOperationId;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    RESOLVE_INCIDENT("RESOLVE_INCIDENT"),
    
    CANCEL_PROCESS_INSTANCE("CANCEL_PROCESS_INSTANCE"),
    
    DELETE_PROCESS_INSTANCE("DELETE_PROCESS_INSTANCE"),
    
    ADD_VARIABLE("ADD_VARIABLE"),
    
    UPDATE_VARIABLE("UPDATE_VARIABLE"),
    
    MODIFY_PROCESS_INSTANCE("MODIFY_PROCESS_INSTANCE"),
    
    DELETE_DECISION_DEFINITION("DELETE_DECISION_DEFINITION"),
    
    DELETE_PROCESS_DEFINITION("DELETE_PROCESS_DEFINITION"),
    
    MIGRATE_PROCESS_INSTANCE("MIGRATE_PROCESS_INSTANCE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private TypeEnum type;

  /**
   * Gets or Sets state
   */
  public enum StateEnum {
    SCHEDULED("SCHEDULED"),
    
    LOCKED("LOCKED"),
    
    SENT("SENT"),
    
    FAILED("FAILED"),
    
    COMPLETED("COMPLETED");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private StateEnum state;

  private String errorMessage;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private String completedDate;

  public OperationItem id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  
  @Schema(name = "id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public OperationItem batchOperationId(String batchOperationId) {
    this.batchOperationId = batchOperationId;
    return this;
  }

  /**
   * Get batchOperationId
   * @return batchOperationId
   */
  
  @Schema(name = "batchOperationId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("batchOperationId")
  public String getBatchOperationId() {
    return batchOperationId;
  }

  public void setBatchOperationId(String batchOperationId) {
    this.batchOperationId = batchOperationId;
  }

  public OperationItem type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
   */
  
  @Schema(name = "type", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public OperationItem state(StateEnum state) {
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
   */
  
  @Schema(name = "state", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("state")
  public StateEnum getState() {
    return state;
  }

  public void setState(StateEnum state) {
    this.state = state;
  }

  public OperationItem errorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * Get errorMessage
   * @return errorMessage
   */
  
  @Schema(name = "errorMessage", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("errorMessage")
  public String getErrorMessage() {
    return errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public OperationItem completedDate(String completedDate) {
    this.completedDate = completedDate;
    return this;
  }

  /**
   * Get completedDate
   * @return completedDate
   */
  @Valid 
  @Schema(name = "completedDate", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("completedDate")
  public String getCompletedDate() {
    return completedDate;
  }

  public void setCompletedDate(String completedDate) {
    this.completedDate = completedDate;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationItem operationItem = (OperationItem) o;
    return Objects.equals(this.id, operationItem.id) &&
        Objects.equals(this.batchOperationId, operationItem.batchOperationId) &&
        Objects.equals(this.type, operationItem.type) &&
        Objects.equals(this.state, operationItem.state) &&
        Objects.equals(this.errorMessage, operationItem.errorMessage) &&
        Objects.equals(this.completedDate, operationItem.completedDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, batchOperationId, type, state, errorMessage, completedDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationItem {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    batchOperationId: ").append(toIndentedString(batchOperationId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    completedDate: ").append(toIndentedString(completedDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

