package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Instructions describing which variables should be created.
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "ModifyProcessInstanceVariableInstruction", description = "Instructions describing which variables should be created.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class ModifyProcessInstanceVariableInstruction {

  @Valid
  private Map<String, Object> variables = new HashMap<>();

  private String scopeId = "";

  public ModifyProcessInstanceVariableInstruction() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public ModifyProcessInstanceVariableInstruction(Map<String, Object> variables) {
    this.variables = variables;
  }

  public ModifyProcessInstanceVariableInstruction variables(Map<String, Object> variables) {
    this.variables = variables;
    return this;
  }

  public ModifyProcessInstanceVariableInstruction putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * JSON document that will instantiate the variables for the root variable scope of the process instance. It must be a JSON object, as variables will be mapped in a key-value fashion. 
   * @return variables
   */
  @NotNull 
  @Schema(name = "variables", description = "JSON document that will instantiate the variables for the root variable scope of the process instance. It must be a JSON object, as variables will be mapped in a key-value fashion. ", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("variables")
  public Map<String, Object> getVariables() {
    return variables;
  }

  public void setVariables(Map<String, Object> variables) {
    this.variables = variables;
  }

  public ModifyProcessInstanceVariableInstruction scopeId(String scopeId) {
    this.scopeId = scopeId;
    return this;
  }

  /**
   * The ID of the element in which scope the variables should be created. Leave empty to create the variables in the global scope of the process instance 
   * @return scopeId
   */
  
  @Schema(name = "scopeId", description = "The ID of the element in which scope the variables should be created. Leave empty to create the variables in the global scope of the process instance ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("scopeId")
  public String getScopeId() {
    return scopeId;
  }

  public void setScopeId(String scopeId) {
    this.scopeId = scopeId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ModifyProcessInstanceVariableInstruction modifyProcessInstanceVariableInstruction = (ModifyProcessInstanceVariableInstruction) o;
    return Objects.equals(this.variables, modifyProcessInstanceVariableInstruction.variables) &&
        Objects.equals(this.scopeId, modifyProcessInstanceVariableInstruction.scopeId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variables, scopeId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ModifyProcessInstanceVariableInstruction {\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    scopeId: ").append(toIndentedString(scopeId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

