package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Instructions describing which elements should be terminated.
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "ModifyProcessInstanceTerminateInstruction", description = "Instructions describing which elements should be terminated.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class ModifyProcessInstanceTerminateInstruction {

  private Long elementInstanceKey;

  public ModifyProcessInstanceTerminateInstruction() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public ModifyProcessInstanceTerminateInstruction(Long elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
  }

  public ModifyProcessInstanceTerminateInstruction elementInstanceKey(Long elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
    return this;
  }

  /**
   * The ID of the element that should be terminated.
   * @return elementInstanceKey
   */
  @NotNull 
  @Schema(name = "elementInstanceKey", description = "The ID of the element that should be terminated.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("elementInstanceKey")
  public Long getElementInstanceKey() {
    return elementInstanceKey;
  }

  public void setElementInstanceKey(Long elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ModifyProcessInstanceTerminateInstruction modifyProcessInstanceTerminateInstruction = (ModifyProcessInstanceTerminateInstruction) o;
    return Objects.equals(this.elementInstanceKey, modifyProcessInstanceTerminateInstruction.elementInstanceKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(elementInstanceKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ModifyProcessInstanceTerminateInstruction {\n");
    sb.append("    elementInstanceKey: ").append(toIndentedString(elementInstanceKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

