package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.gateway.protocol.rest.ModifyProcessInstanceActivateInstruction;
import io.camunda.zeebe.gateway.protocol.rest.ModifyProcessInstanceTerminateInstruction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * ModifyProcessInstanceRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class ModifyProcessInstanceRequest {

  @Valid
  private List<@Valid ModifyProcessInstanceActivateInstruction> activateInstructions = new ArrayList<>();

  @Valid
  private List<@Valid ModifyProcessInstanceTerminateInstruction> terminateInstructions = new ArrayList<>();

  private Long operationReference;

  public ModifyProcessInstanceRequest activateInstructions(List<@Valid ModifyProcessInstanceActivateInstruction> activateInstructions) {
    this.activateInstructions = activateInstructions;
    return this;
  }

  public ModifyProcessInstanceRequest addActivateInstructionsItem(ModifyProcessInstanceActivateInstruction activateInstructionsItem) {
    if (this.activateInstructions == null) {
      this.activateInstructions = new ArrayList<>();
    }
    this.activateInstructions.add(activateInstructionsItem);
    return this;
  }

  /**
   * Get activateInstructions
   * @return activateInstructions
   */
  @Valid 
  @Schema(name = "activateInstructions", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("activateInstructions")
  public List<@Valid ModifyProcessInstanceActivateInstruction> getActivateInstructions() {
    return activateInstructions;
  }

  public void setActivateInstructions(List<@Valid ModifyProcessInstanceActivateInstruction> activateInstructions) {
    this.activateInstructions = activateInstructions;
  }

  public ModifyProcessInstanceRequest terminateInstructions(List<@Valid ModifyProcessInstanceTerminateInstruction> terminateInstructions) {
    this.terminateInstructions = terminateInstructions;
    return this;
  }

  public ModifyProcessInstanceRequest addTerminateInstructionsItem(ModifyProcessInstanceTerminateInstruction terminateInstructionsItem) {
    if (this.terminateInstructions == null) {
      this.terminateInstructions = new ArrayList<>();
    }
    this.terminateInstructions.add(terminateInstructionsItem);
    return this;
  }

  /**
   * Get terminateInstructions
   * @return terminateInstructions
   */
  @Valid 
  @Schema(name = "terminateInstructions", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("terminateInstructions")
  public List<@Valid ModifyProcessInstanceTerminateInstruction> getTerminateInstructions() {
    return terminateInstructions;
  }

  public void setTerminateInstructions(List<@Valid ModifyProcessInstanceTerminateInstruction> terminateInstructions) {
    this.terminateInstructions = terminateInstructions;
  }

  public ModifyProcessInstanceRequest operationReference(Long operationReference) {
    this.operationReference = operationReference;
    return this;
  }

  /**
   * A reference key chosen by the user that will be part of all records resulting from this operation. Must be > 0 if provided. 
   * minimum: 1
   * @return operationReference
   */
  @Min(1L) 
  @Schema(name = "operationReference", description = "A reference key chosen by the user that will be part of all records resulting from this operation. Must be > 0 if provided. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("operationReference")
  public Long getOperationReference() {
    return operationReference;
  }

  public void setOperationReference(Long operationReference) {
    this.operationReference = operationReference;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ModifyProcessInstanceRequest modifyProcessInstanceRequest = (ModifyProcessInstanceRequest) o;
    return Objects.equals(this.activateInstructions, modifyProcessInstanceRequest.activateInstructions) &&
        Objects.equals(this.terminateInstructions, modifyProcessInstanceRequest.terminateInstructions) &&
        Objects.equals(this.operationReference, modifyProcessInstanceRequest.operationReference);
  }

  @Override
  public int hashCode() {
    return Objects.hash(activateInstructions, terminateInstructions, operationReference);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ModifyProcessInstanceRequest {\n");
    sb.append("    activateInstructions: ").append(toIndentedString(activateInstructions)).append("\n");
    sb.append("    terminateInstructions: ").append(toIndentedString(terminateInstructions)).append("\n");
    sb.append("    operationReference: ").append(toIndentedString(operationReference)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

