package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.gateway.protocol.rest.ModifyProcessInstanceVariableInstruction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Instructions describing which elements should be activated in which scopes and which variables should be created. 
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "ModifyProcessInstanceActivateInstruction", description = "Instructions describing which elements should be activated in which scopes and which variables should be created. ")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class ModifyProcessInstanceActivateInstruction {

  private String elementId;

  private Long ancestorElementInstanceKey = -1l;

  @Valid
  private List<@Valid ModifyProcessInstanceVariableInstruction> variableInstructions = new ArrayList<>();

  public ModifyProcessInstanceActivateInstruction() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public ModifyProcessInstanceActivateInstruction(String elementId) {
    this.elementId = elementId;
  }

  public ModifyProcessInstanceActivateInstruction elementId(String elementId) {
    this.elementId = elementId;
    return this;
  }

  /**
   * The ID of the element that should be activated.
   * @return elementId
   */
  @NotNull 
  @Schema(name = "elementId", description = "The ID of the element that should be activated.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("elementId")
  public String getElementId() {
    return elementId;
  }

  public void setElementId(String elementId) {
    this.elementId = elementId;
  }

  public ModifyProcessInstanceActivateInstruction ancestorElementInstanceKey(Long ancestorElementInstanceKey) {
    this.ancestorElementInstanceKey = ancestorElementInstanceKey;
    return this;
  }

  /**
   * The key of the ancestor scope the element instance should be created in. Set to -1 to create the new element instance within an existing element instance of the flow scope. 
   * @return ancestorElementInstanceKey
   */
  
  @Schema(name = "ancestorElementInstanceKey", description = "The key of the ancestor scope the element instance should be created in. Set to -1 to create the new element instance within an existing element instance of the flow scope. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("ancestorElementInstanceKey")
  public Long getAncestorElementInstanceKey() {
    return ancestorElementInstanceKey;
  }

  public void setAncestorElementInstanceKey(Long ancestorElementInstanceKey) {
    this.ancestorElementInstanceKey = ancestorElementInstanceKey;
  }

  public ModifyProcessInstanceActivateInstruction variableInstructions(List<@Valid ModifyProcessInstanceVariableInstruction> variableInstructions) {
    this.variableInstructions = variableInstructions;
    return this;
  }

  public ModifyProcessInstanceActivateInstruction addVariableInstructionsItem(ModifyProcessInstanceVariableInstruction variableInstructionsItem) {
    if (this.variableInstructions == null) {
      this.variableInstructions = new ArrayList<>();
    }
    this.variableInstructions.add(variableInstructionsItem);
    return this;
  }

  /**
   * Get variableInstructions
   * @return variableInstructions
   */
  @Valid 
  @Schema(name = "variableInstructions", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("variableInstructions")
  public List<@Valid ModifyProcessInstanceVariableInstruction> getVariableInstructions() {
    return variableInstructions;
  }

  public void setVariableInstructions(List<@Valid ModifyProcessInstanceVariableInstruction> variableInstructions) {
    this.variableInstructions = variableInstructions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ModifyProcessInstanceActivateInstruction modifyProcessInstanceActivateInstruction = (ModifyProcessInstanceActivateInstruction) o;
    return Objects.equals(this.elementId, modifyProcessInstanceActivateInstruction.elementId) &&
        Objects.equals(this.ancestorElementInstanceKey, modifyProcessInstanceActivateInstruction.ancestorElementInstanceKey) &&
        Objects.equals(this.variableInstructions, modifyProcessInstanceActivateInstruction.variableInstructions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(elementId, ancestorElementInstanceKey, variableInstructions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ModifyProcessInstanceActivateInstruction {\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    ancestorElementInstanceKey: ").append(toIndentedString(ancestorElementInstanceKey)).append("\n");
    sb.append("    variableInstructions: ").append(toIndentedString(variableInstructions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

