package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.gateway.protocol.rest.MigrateProcessInstanceMappingInstruction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * MigrateProcessInstanceRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class MigrateProcessInstanceRequest {

  private Long targetProcessDefinitionKey;

  @Valid
  private List<@Valid MigrateProcessInstanceMappingInstruction> mappingInstructions = new ArrayList<>();

  private Long operationReference;

  public MigrateProcessInstanceRequest() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public MigrateProcessInstanceRequest(Long targetProcessDefinitionKey, List<@Valid MigrateProcessInstanceMappingInstruction> mappingInstructions) {
    this.targetProcessDefinitionKey = targetProcessDefinitionKey;
    this.mappingInstructions = mappingInstructions;
  }

  public MigrateProcessInstanceRequest targetProcessDefinitionKey(Long targetProcessDefinitionKey) {
    this.targetProcessDefinitionKey = targetProcessDefinitionKey;
    return this;
  }

  /**
   * The key of process definition to migrate the process instance to.
   * @return targetProcessDefinitionKey
   */
  @NotNull 
  @Schema(name = "targetProcessDefinitionKey", description = "The key of process definition to migrate the process instance to.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("targetProcessDefinitionKey")
  public Long getTargetProcessDefinitionKey() {
    return targetProcessDefinitionKey;
  }

  public void setTargetProcessDefinitionKey(Long targetProcessDefinitionKey) {
    this.targetProcessDefinitionKey = targetProcessDefinitionKey;
  }

  public MigrateProcessInstanceRequest mappingInstructions(List<@Valid MigrateProcessInstanceMappingInstruction> mappingInstructions) {
    this.mappingInstructions = mappingInstructions;
    return this;
  }

  public MigrateProcessInstanceRequest addMappingInstructionsItem(MigrateProcessInstanceMappingInstruction mappingInstructionsItem) {
    if (this.mappingInstructions == null) {
      this.mappingInstructions = new ArrayList<>();
    }
    this.mappingInstructions.add(mappingInstructionsItem);
    return this;
  }

  /**
   * Get mappingInstructions
   * @return mappingInstructions
   */
  @NotNull @Valid 
  @Schema(name = "mappingInstructions", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("mappingInstructions")
  public List<@Valid MigrateProcessInstanceMappingInstruction> getMappingInstructions() {
    return mappingInstructions;
  }

  public void setMappingInstructions(List<@Valid MigrateProcessInstanceMappingInstruction> mappingInstructions) {
    this.mappingInstructions = mappingInstructions;
  }

  public MigrateProcessInstanceRequest operationReference(Long operationReference) {
    this.operationReference = operationReference;
    return this;
  }

  /**
   * A reference key chosen by the user that will be part of all records resulting from this operation. Must be > 0 if provided. 
   * minimum: 1
   * @return operationReference
   */
  @Min(1L) 
  @Schema(name = "operationReference", description = "A reference key chosen by the user that will be part of all records resulting from this operation. Must be > 0 if provided. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("operationReference")
  public Long getOperationReference() {
    return operationReference;
  }

  public void setOperationReference(Long operationReference) {
    this.operationReference = operationReference;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MigrateProcessInstanceRequest migrateProcessInstanceRequest = (MigrateProcessInstanceRequest) o;
    return Objects.equals(this.targetProcessDefinitionKey, migrateProcessInstanceRequest.targetProcessDefinitionKey) &&
        Objects.equals(this.mappingInstructions, migrateProcessInstanceRequest.mappingInstructions) &&
        Objects.equals(this.operationReference, migrateProcessInstanceRequest.operationReference);
  }

  @Override
  public int hashCode() {
    return Objects.hash(targetProcessDefinitionKey, mappingInstructions, operationReference);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MigrateProcessInstanceRequest {\n");
    sb.append("    targetProcessDefinitionKey: ").append(toIndentedString(targetProcessDefinitionKey)).append("\n");
    sb.append("    mappingInstructions: ").append(toIndentedString(mappingInstructions)).append("\n");
    sb.append("    operationReference: ").append(toIndentedString(operationReference)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

