package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * The mapping instructions describe how to map elements from the source process definition to the target process definition. 
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "MigrateProcessInstanceMappingInstruction", description = "The mapping instructions describe how to map elements from the source process definition to the target process definition. ")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class MigrateProcessInstanceMappingInstruction {

  private String sourceElementId;

  private String targetElementId;

  public MigrateProcessInstanceMappingInstruction() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public MigrateProcessInstanceMappingInstruction(String sourceElementId, String targetElementId) {
    this.sourceElementId = sourceElementId;
    this.targetElementId = targetElementId;
  }

  public MigrateProcessInstanceMappingInstruction sourceElementId(String sourceElementId) {
    this.sourceElementId = sourceElementId;
    return this;
  }

  /**
   * The element ID to migrate from.
   * @return sourceElementId
   */
  @NotNull 
  @Schema(name = "sourceElementId", description = "The element ID to migrate from.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("sourceElementId")
  public String getSourceElementId() {
    return sourceElementId;
  }

  public void setSourceElementId(String sourceElementId) {
    this.sourceElementId = sourceElementId;
  }

  public MigrateProcessInstanceMappingInstruction targetElementId(String targetElementId) {
    this.targetElementId = targetElementId;
    return this;
  }

  /**
   * The element ID to migrate into.
   * @return targetElementId
   */
  @NotNull 
  @Schema(name = "targetElementId", description = "The element ID to migrate into.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("targetElementId")
  public String getTargetElementId() {
    return targetElementId;
  }

  public void setTargetElementId(String targetElementId) {
    this.targetElementId = targetElementId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MigrateProcessInstanceMappingInstruction migrateProcessInstanceMappingInstruction = (MigrateProcessInstanceMappingInstruction) o;
    return Objects.equals(this.sourceElementId, migrateProcessInstanceMappingInstruction.sourceElementId) &&
        Objects.equals(this.targetElementId, migrateProcessInstanceMappingInstruction.targetElementId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceElementId, targetElementId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MigrateProcessInstanceMappingInstruction {\n");
    sb.append("    sourceElementId: ").append(toIndentedString(sourceElementId)).append("\n");
    sb.append("    targetElementId: ").append(toIndentedString(targetElementId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

