package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * The message key of the published message.
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "MessagePublicationResponse", description = "The message key of the published message.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class MessagePublicationResponse {

  private Long messageKey;

  private String tenantId;

  public MessagePublicationResponse messageKey(Long messageKey) {
    this.messageKey = messageKey;
    return this;
  }

  /**
   * The key of the message
   * @return messageKey
   */
  
  @Schema(name = "messageKey", description = "The key of the message", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("messageKey")
  public Long getMessageKey() {
    return messageKey;
  }

  public void setMessageKey(Long messageKey) {
    this.messageKey = messageKey;
  }

  public MessagePublicationResponse tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the message.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant ID of the message.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MessagePublicationResponse messagePublicationResponse = (MessagePublicationResponse) o;
    return Objects.equals(this.messageKey, messagePublicationResponse.messageKey) &&
        Objects.equals(this.tenantId, messagePublicationResponse.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(messageKey, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MessagePublicationResponse {\n");
    sb.append("    messageKey: ").append(toIndentedString(messageKey)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

